<?php

if (!class_exists('XmlExportWooCommerceCustomer')) {

    final class XmlExportWooCommerceCustomer
    {
        private static $engine = false;

    	private $init_fields = array(
            array(
                'label' => 'id',
                'name' => 'ID',
                'type' => 'id'
            ),
            array(
                'label' => 'user_email',
                'name' => 'User Email',
                'type' => 'user_email'
            ),
            array(
                'label' => 'user_login',
                'name' => 'User Login',
                'type' => 'user_login'
            )
        );

        private $default_fields = array(
            array(
                'label' => 'id',
                'name' => 'ID',
                'type' => 'id'
            ),
            array(
                'label' => 'user_login',
                'name' => 'Username',
                'type' => 'user_login'
            ),
            array(
                'label' => 'user_email',
                'name' => 'User Email',
                'type' => 'user_email'
            ),
            array(
                'label' => 'first_name',
                'name' => 'First Name',
                'type' => 'first_name'
            ),
            array(
                'label' => 'last_name',
                'name' => 'Last Name',
                'type' => 'last_name'
            ),
            array(
                'label' => 'user_registered',
                'name' => 'User Registered',
                'type' => 'user_registered'
            ),
            array(
                'label' => 'user_nicename',
                'name' => 'User Nicename',
                'type' => 'user_nicename'
            ),
            array(
                'label' => 'user_url',
                'name' => 'User URL',
                'type' => 'user_url'
            ),
            array(
                'label' => 'display_name',
                'name' => 'Display Name',
                'type' => 'display_name'
            ),
            array(
                'label' => 'nickname',
                'name' => 'Nickname',
                'type' => 'nickname'
            ),
            array(
                'label' => 'description',
                'name' => 'Description',
                'type' => 'description'
            )
        );

        private $advanced_fields = array(
            array(
                'label' => 'wp_capabilities',
                'name' => 'User Role',
                'type' => 'wp_capabilities'
            ),
            array(
                'label' => 'user_pass',
                'name' => 'User Pass',
                'type' => 'user_pass'
            ),
            array(
                'label' => 'user_activation_key',
                'name' => 'User Activation Key',
                'type' => 'user_activation_key'
            ),
            array(
                'label' => 'user_status',
                'name' => 'User Status',
                'type' => 'user_status'
            )
        );

        private $user_core_fields = array();

        public static $is_active = true;

        public function __construct()
        {

            $this->user_core_fields = array('rich_editing', 'comment_shortcuts', 'admin_color', 'use_ssl', 'show_admin_bar_front', 'wp_user_level', 'show_welcome_panel', 'dismissed_wp_pointers', 'session_tokens', 'wp_user-settings', 'wp_user-settings-time', 'wp_dashboard_quick_press_last_post_id', 'metaboxhidden_dashboard', 'closedpostboxes_dashboard', 'wp_nav_menu_recently_edited', 'meta-box-order_dashboard', 'closedpostboxes_product', 'metaboxhidden_product', 'manageedit-shop_ordercolumnshidden', 'aim', 'yim', 'jabber', 'wp_media_library_mode');

            if ((XmlExportEngine::$exportOptions['export_type'] == 'specific' and !in_array('shop_customer', XmlExportEngine::$post_types))
                or (XmlExportEngine::$exportOptions['export_type'] == 'advanced')
            ) {
                self::$is_active = false;
                return;
            }

            self::$is_active = true;

            add_filter("wp_all_export_available_data", array(&$this, "filter_available_data"), 10, 1);
            add_filter("wp_all_export_available_sections", array(&$this, "filter_available_sections"), 10, 1);
            add_filter("wp_all_export_init_fields", array(&$this, "filter_init_fields"), 10, 1);
            add_filter("wp_all_export_default_fields", array(&$this, "filter_default_fields"), 10, 1);
            add_filter("wp_all_export_other_fields", array(&$this, "filter_other_fields"), 10, 1);

        }

        // [FILTERS]

        /**
         *
         * Filter Init Fields
         *
         */
        public function filter_init_fields($init_fields)
        {
            return $this->init_fields;
        }

        /**
         *
         * Filter Default Fields
         *
         */
        public function filter_default_fields($default_fields)
        {
            return $this->default_fields;
        }

        /**
         *
         * Filter Other Fields
         *
         */
        public function filter_other_fields($other_fields)
        {

            $other_fields = array();

            foreach ($this->advanced_fields as $key => $field) {
                $other_fields[] = $field;
            }

            foreach ($this->user_core_fields as $field) {
                $other_fields[] = $this->fix_titles(array(
                    'label' => $field,
                    'name' => $field,
                    'type' => 'cf'
                ));
            }

            return $other_fields;
        }

        /**
         *
         * Filter Available Data
         *
         */
        public function filter_available_data($available_data)
        {

            $available_data['address_fields'] = $this->available_customer_data();

            return $available_data;
        }

        /**
         *
         * Filter Sections in Available Data
         *
         */
        public function filter_available_sections($available_sections)
        {

            unset($available_sections['cats']);
            unset($available_sections['media']);

            $customer_data = array(
                'address' => array(
                    'title' => __("Address", "wp_all_export_plugin"),
                    'content' => 'address_fields'
                )
            );

            return array_merge(array_slice($available_sections, 0, 1), $customer_data, array_slice($available_sections, 1));

        }

        // [\FILTERS]

        public static $meta_keys;

        public function init(& $existing_meta_keys = array())
        {
            if (!self::$is_active) return;

            global $wpdb;
            //$table_prefix = $wpdb->prefix;
            self::$meta_keys = $wpdb->get_results("SELECT DISTINCT " . $wpdb->usermeta . ".meta_key FROM $wpdb->usermeta, $wpdb->users WHERE " . $wpdb->usermeta . ".user_id = " . $wpdb->users . ".ID LIMIT 500");

            $user_ids = array();
            if (!empty(XmlExportEngine::$exportQuery->results)) {
                foreach (XmlExportEngine::$exportQuery->results as $user) :
                    $user_ids[] = $user->ID;
                endforeach;
            }

            if (!empty(self::$meta_keys)) {

                $address_fields = $this->available_customer_data();

                $exclude_keys = array_merge($address_fields, array('_first_variation_attributes', '_is_first_variation_created'));
                foreach (self::$meta_keys as $meta_key) {
                    if (!in_array($meta_key->meta_key, $exclude_keys)) {
                        $to_add = true;
                        foreach ($this->default_fields as $default_value) {
                            if ($meta_key->meta_key == $default_value['name'] || $meta_key->meta_key == $default_value['type']) {
                                $to_add = false;
                                break;
                            }
                        }
                        if ($to_add) {
                            foreach ($this->advanced_fields as $advanced_value) {
                                if ($meta_key->meta_key == $advanced_value['name'] || $meta_key->meta_key == $advanced_value['type']) {
                                    $to_add = false;
                                    break;
                                }
                            }
                        }
                        if ($to_add) {
                            foreach ($this->user_core_fields as $core_field) {
                                if ($meta_key->meta_key == $core_field) {
                                    $to_add = false;
                                    break;
                                }
                            }
                        }
                        if ($to_add) {
                            foreach ($address_fields as $address_value) {
                                if ($meta_key->meta_key == $address_value['label']) {
                                    $to_add = false;
                                    break;
                                }
                            }
                        }
                        if ($to_add) {
                            $existing_meta_keys[] = $meta_key->meta_key;
                        }
                    }
                }
            }
        }

        public function available_customer_data()
        {

            $main_fields = array(
                array(
                    'name' => __('Customer User ID', 'wp_all_export_plugin'),
                    'label' => '_customer_user',
                    'type' => 'cf'
                )
            );

            $data = array_merge($main_fields, $this->available_billing_information_data(), $this->available_shipping_information_data());

            return apply_filters('wp_all_export_available_user_data_filter', $data);

        }

        public function available_billing_information_data()
        {

            $keys = array(
                'billing_first_name', 'billing_last_name', 'billing_company',
                'billing_address_1', 'billing_address_2', 'billing_city',
                'billing_postcode', 'billing_country', 'billing_state',
                'billing_email', 'billing_phone'
            );

            $data = $this->generate_friendly_titles($keys, 'billing');

            return apply_filters('wp_all_export_available_billing_information_data_filter', $data);

        }

        public function available_shipping_information_data()
        {

            $keys = array(
                'shipping_first_name', 'shipping_last_name', 'shipping_company',
                'shipping_address_1', 'shipping_address_2', 'shipping_city',
                'shipping_postcode', 'shipping_country', 'shipping_state'
            );

            $data = $this->generate_friendly_titles($keys, 'shipping');

            return apply_filters('wp_all_export_available_shipping_information_data_filter', $data);

        }

        public function generate_friendly_titles($keys, $keyword = '')
        {
            $data = array();
            foreach ($keys as $key) {

                $key1 = $this->fix_titles(str_replace('_', ' ', $key));
                $key2 = '';

                if (strpos($key1, $keyword) !== false) {
                    $key1 = str_replace($keyword, '', $key1);
                    $key2 = ' (' . __($keyword, 'wp_all_export_plugin') . ')';
                }

                $data[] = array(
                    'name' => __(trim($key1), 'woocommerce') . $key2,
                    'label' => $key,
                    'type' => 'cf'
                );

            }
            return $data;
        }

        /**
         *
         * Helper method to fix fields title
         *
         */
        protected function fix_titles($field)
        {
            if (is_array($field)) {
                $field['name'] = $this->fix_title($field['name']);
            } else {
                $field = $this->fix_title($field);
            }
            return $field;
        }

        /**
         *
         * Helper method to fix single title
         *
         */
        protected function fix_title($title)
        {
            $uc_title = ucwords(trim(str_replace("-", " ", str_replace("_", " ", $title))));

            return stripos($uc_title, "width") === false ? str_ireplace(array('id', 'url', 'sku', 'wp', 'ssl'), array('ID', 'URL', 'SKU', 'WP', 'SSL'), $uc_title) : $uc_title;
        }

        public static function prepare_data($user, $exportOptions, $xmlWriter, &$acfs, $implode_delimiter, $preview)
        {
            $article = array();

            // associate exported user with import
            if (wp_all_export_is_compatible() and isset($exportOptions['is_generate_import']) and $exportOptions['is_generate_import'] and $exportOptions['import_id']) {
                $postRecord = new PMXI_Post_Record();
                $postRecord->clear();
                $postRecord->getBy(array(
                    'post_id' => $user->ID,
                    'import_id' => $exportOptions['import_id'],
                ));

                if ($postRecord->isEmpty()) {
                    $postRecord->set(array(
                        'post_id' => $user->ID,
                        'import_id' => $exportOptions['import_id'],
                        'unique_key' => $user->ID
                    ))->save();
                }
                unset($postRecord);
            }

            $is_xml_export = false;

            if (!empty($xmlWriter) and $exportOptions['export_to'] == 'xml' and !in_array($exportOptions['xml_template_type'], array('custom', 'XmlGoogleMerchants'))) {
                $is_xml_export = true;
            }

            if(isset($exportOptions['ids']) && is_array($exportOptions['ids'])) {

                foreach ($exportOptions['ids'] as $ID => $value) {
                    $fieldName = apply_filters('wp_all_export_field_name', wp_all_export_parse_field_name($exportOptions['cc_name'][$ID]), XmlExportEngine::$exportID);
                    $fieldValue = $exportOptions['cc_value'][$ID];
                    $fieldLabel = $exportOptions['cc_label'][$ID];
                    $fieldSql = $exportOptions['cc_sql'][$ID];
                    $fieldPhp = $exportOptions['cc_php'][$ID];
                    $fieldCode = $exportOptions['cc_code'][$ID];
                    $fieldType = $exportOptions['cc_type'][$ID];
                    $fieldOptions = $exportOptions['cc_options'][$ID];
                    $fieldSettings = empty($exportOptions['cc_settings'][$ID]) ? $fieldOptions : $exportOptions['cc_settings'][$ID];

                    if (empty($fieldName) or empty($fieldType) or !is_numeric($ID)) continue;

                    $element_name = (!empty($fieldName)) ? $fieldName : 'untitled_' . $ID;
                    $element_name_ns = '';

                    if ($is_xml_export) {
                        $element_name = (!empty($fieldName)) ? preg_replace('/[^a-z0-9_:-]/i', '', $fieldName) : 'untitled_' . $ID;

                        if (strpos($element_name, ":") !== false) {
                            $element_name_parts = explode(":", $element_name);
                            $element_name_ns = (empty($element_name_parts[0])) ? '' : $element_name_parts[0];
                            $element_name = (empty($element_name_parts[1])) ? 'untitled_' . $ID : preg_replace('/[^a-z0-9_-]/i', '', $element_name_parts[1]);
                        }
                    }

                    $fieldSnipped = (!empty($fieldPhp) and !empty($fieldCode)) ? $fieldCode : false;

                    if (!empty($exportOptions['cc_combine_multiple_fields']) && $exportOptions['cc_combine_multiple_fields'][$ID]) {
                        $combineMultipleFieldsValue = $exportOptions['cc_combine_multiple_fields_value'][$ID];

                        $combineMultipleFieldsValue = stripslashes($combineMultipleFieldsValue);
                        $snippetParser = new \Wpae\App\Service\SnippetParser();
                        $snippets = $snippetParser->parseSnippets($combineMultipleFieldsValue);

                        // Re-use the engine object if we've already initialized it as it's costly.
	                    if(!is_object(self::$engine)){

		                    self::$engine = new XmlExportEngine(XmlExportEngine::$exportOptions);
		                    self::$engine->init_available_data();
		                    self::$engine->init_additional_data();

	                    }

                        $snippets = self::$engine->get_fields_options($snippets);

                        $articleData = self::prepare_data($user, $snippets, $xmlWriter, $acfs, $implode_delimiter, $preview);

	                    $combineMultipleFieldsValue = \Wpae\App\Service\CombineFields::prepareMultipleFieldsValue($articleData, true, $combineMultipleFieldsValue, $preview);
                        if ($preview) {
                            $combineMultipleFieldsValue = trim(preg_replace('~[\r\n]+~', ' ', htmlspecialchars($combineMultipleFieldsValue)));
                        }

                        wp_all_export_write_article($article, $element_name, pmxe_filter($combineMultipleFieldsValue, $fieldSnipped));
                    } else {
	                    // Run addons export field hooks, check if supported before running
	                    if (method_exists('XmlExportEngine', 'get_addons')) {
		                    $addons = XmlExportEngine::get_addons();
		                    $addonFieldOptions = maybe_unserialize($fieldOptions);

		                    if (in_array($fieldType, $addons)) {
			                    $article = apply_filters(
				                    "pmxe_{$fieldType}_addon_export_field",
				                    $article,
				                    $addonFieldOptions,
				                    $exportOptions,
				                    $ID,
				                    $user,
				                    $user->ID,
				                    $xmlWriter,
				                    $element_name,
				                    $element_name_ns,
				                    $fieldSnipped,
				                    $preview
			                    );
		                    }
	                    }
						
                        switch ($fieldType) {
                            case 'id':
                                // For ID columns make first element in lowercase for Excel export
                                if ($element_name == 'ID' && !$ID && isset($exportOptions['export_to']) && $exportOptions['export_to'] == 'csv' && isset($exportOptions['export_to_sheet']) && $exportOptions['export_to_sheet'] != 'csv') {
                                    $element_name = 'id';
                                }
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_id', pmxe_filter($user->ID, $fieldSnipped), $user->ID));
                                break;
                            case 'user_login':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_login', pmxe_filter($user->user_login, $fieldSnipped), $user->ID));
                                break;
                            case 'user_pass':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_pass', pmxe_filter($user->user_pass, $fieldSnipped), $user->ID));
                                break;
                            case 'user_email':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_email', pmxe_filter($user->user_email, $fieldSnipped), $user->ID));
                                break;
                            case 'user_nicename':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_nicename', pmxe_filter($user->user_nicename, $fieldSnipped), $user->ID));
                                break;
                            case 'user_url':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_url', pmxe_filter($user->user_url, $fieldSnipped), $user->ID));
                                break;
                            case 'user_activation_key':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_activation_key', pmxe_filter($user->user_activation_key, $fieldSnipped), $user->ID));
                                break;
                            case 'user_status':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_status', pmxe_filter($user->user_status, $fieldSnipped), $user->ID));
                                break;
                            case 'display_name':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_display_name', pmxe_filter($user->display_name, $fieldSnipped), $user->ID));
                                break;
                            case 'nickname':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_nickname', pmxe_filter($user->nickname, $fieldSnipped), $user->ID));
                                break;
                            case 'first_name':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_first_name', pmxe_filter($user->first_name, $fieldSnipped), $user->ID));
                                break;
                            case 'last_name':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_last_name', pmxe_filter($user->last_name, $fieldSnipped), $user->ID));
                                break;
                            case 'wp_capabilities':
                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_wp_capabilities', pmxe_filter(implode($implode_delimiter, $user->roles), $fieldSnipped), $user->ID));
                                break;
                            case 'description':
                                $val = apply_filters('pmxe_user_description', pmxe_filter($user->description, $fieldSnipped), $user->ID);
                                wp_all_export_write_article($article, $element_name, ($preview) ? trim(preg_replace('~[\r\n]+~', ' ', htmlspecialchars($val))) : $val);
                                break;
                            case 'user_registered':

                                if (empty($fieldSettings))
                                    $fieldSettings = 'Y-m-d H:i:s'; // default to using datetime

                                $post_date = prepare_date_field_value($fieldSettings, strtotime($user->user_registered));

                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_user_registered', pmxe_filter($post_date, $fieldSnipped), $user->ID));

                                break;
                            case 'cf':
                                $specialCf = array('_order_count', '_money_spent');

                                if (!in_array($fieldLabel, $specialCf)) {
                                    if (!empty($fieldValue)) {

                                        $val = "";

                                        $cur_meta_values = get_user_meta($user->ID, $fieldValue);

                                        if (!empty($cur_meta_values) and is_array($cur_meta_values)) {
                                            foreach ($cur_meta_values as $key => $cur_meta_value) {
                                                if (empty($val)) {
                                                    $val = apply_filters('pmxe_custom_field', pmxe_filter(maybe_serialize($cur_meta_value), $fieldSnipped), $fieldValue, $user->ID);
                                                } else {
                                                    $val = apply_filters('pmxe_custom_field', pmxe_filter($val . $implode_delimiter . maybe_serialize($cur_meta_value), $fieldSnipped), $fieldValue, $user->ID);
                                                }
                                            }
                                            wp_all_export_write_article($article, $element_name, $val);
                                        }

                                        if (empty($cur_meta_values)) {
                                            if (empty($article[$element_name])) {
                                                wp_all_export_write_article($article, $element_name, apply_filters('pmxe_custom_field', pmxe_filter('', $fieldSnipped), $fieldValue, $user->ID));
                                            }
                                        }
                                    }

                                } else {

                                    $val = "";

                                    if ($fieldLabel == '_order_count') {
                                        if (function_exists('wc_get_customer_order_count')) {
                                            $val = wc_get_customer_order_count($user->ID);
                                        }

                                    } else if ($fieldLabel == '_money_spent') {
                                        if (function_exists('wc_get_customer_total_spent')) {
                                            $val = wc_get_customer_total_spent($user->ID);
                                        }
                                    }

                                    if (empty($val)) {
                                        $val = 0;
                                    }
                                    $val = apply_filters('pmxe_custom_field', pmxe_filter($val, $fieldSnipped), $fieldValue, $user->ID);

                                    wp_all_export_write_article($article, $element_name, $val);

                                }

                                break;
                            case 'acf':

                                if (!empty($fieldLabel) and class_exists('acf')) {
                                    global $acf;

                                    $field_options = unserialize($fieldOptions);

                                    if (!$is_xml_export) {
                                            switch ($field_options['type']) {
                                                case 'textarea':
                                                case 'oembed':
                                                case 'wysiwyg':
                                                case 'wp_wysiwyg':
                                                case 'date_time_picker':
                                                case 'date_picker':

                                                    $field_value = get_field($fieldLabel, 'user_' . $user->ID, false);

                                                    break;

                                                default:

                                                    $field_value = get_field($fieldLabel, 'user_' . $user->ID);

                                                    break;
                                            }
                                        } else {
                                            $field_value = get_field($fieldLabel, 'user_' . $user->ID);
                                    }

                                    XmlExportACF::export_acf_field(
                                        $field_value,
                                        $exportOptions,
                                        $ID,
                                        'user_' . $user->ID,
                                        $article,
                                        $xmlWriter,
                                        $acfs,
                                        $element_name,
                                        $element_name_ns,
                                        $fieldSnipped,
                                        $field_options['group_id'],
                                        $preview
                                    );

                                }

                                break;
                            case 'sql':

                                if (!empty($fieldSql)) {
                                    global $wpdb;
                                    $val = $wpdb->get_var($wpdb->prepare(stripcslashes(str_replace("%%ID%%", "%d", $fieldSql)), $user->ID));
                                    if (!empty($fieldPhp) and !empty($fieldCode)) {
                                        // if shortcode defined
                                        if (strpos($fieldCode, '[') === 0) {
                                            $val = do_shortcode(str_replace("%%VALUE%%", $val, $fieldCode));
                                        } else {
                                            $val = eval('return ' . stripcslashes(str_replace("%%VALUE%%", $val, $fieldCode)) . ';');
                                        }
                                    }
                                    wp_all_export_write_article($article, $element_name, apply_filters('pmxe_sql_field', $val, $element_name, $user->ID));
                                }
                                break;
                            default:
                                # code...
                                break;
                        }
                    }
                    if ($is_xml_export and isset($article[$element_name])) {
                        $element_name_in_file = XmlCsvExport::_get_valid_header_name($element_name);

                        $xmlWriter = apply_filters('wp_all_export_add_before_element', $xmlWriter, $element_name_in_file, XmlExportEngine::$exportID, $user->ID);

                        $xmlWriter->beginElement($element_name_ns, $element_name_in_file, null);
                        $xmlWriter->writeData($article[$element_name], $element_name_in_file);
                        $xmlWriter->closeElement();

                        $xmlWriter = apply_filters('wp_all_export_add_after_element', $xmlWriter, $element_name_in_file, XmlExportEngine::$exportID, $user->ID);
                    }
                }
            }
            return $article;
        }

        public static function prepare_import_template($exportOptions, &$templateOptions, &$bill_list, &$ship_list, $element_name, $ID)
        {

            $options = $exportOptions;

            $element_value = $options['cc_value'][$ID];

            $billing_keys = array(
                'billing_first_name',  'billing_last_name', 'billing_company',
                'billing_address_1', 'billing_address_2', 'billing_city',
                'billing_postcode', 'billing_country', 'billing_state',
                'billing_email', 'billing_phone'
            );

            $shipping_keys = array(
                'shipping_first_name', 'shipping_last_name', 'shipping_company',
                'shipping_address_1', 'shipping_address_2', 'shipping_city',
                'shipping_postcode', 'shipping_country', 'shipping_state'
            );

            $is_xml_template = $options['export_to'] == 'xml';

            $implode_delimiter = XmlExportEngine::$implode;

            switch ($element_value) {
                // Export Customers
                case 'user_login':
                    $templateOptions['pmsci_customer']['login'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_login'] = 1;
                    break;
                case 'user_pass':
                    $templateOptions['pmsci_customer']['pass'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_password'] = 1;
                    $templateOptions['is_hashed_wordpress_password'] = 1;
                    break;
                case 'user_nicename':
                    $templateOptions['pmsci_customer']['nicename'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_nicename'] = 1;
                    break;
                case 'user_email':
                    $templateOptions['pmsci_customer']['email'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_email'] = 1;
                    break;
                case 'user_registered':
                    $templateOptions['pmsci_customer']['registered'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_registered'] = 1;
                    break;
                case 'display_name':
                    $templateOptions['pmsci_customer']['display_name'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_display_name'] = 1;
                    break;
                case 'user_url':
                    $templateOptions['pmsci_customer']['url'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_url'] = 1;
                    break;

                case 'first_name':
                    $templateOptions['pmsci_customer']['first_name'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_first_name'] = 1;
                    break;
                case 'last_name':
                    $templateOptions['pmsci_customer']['last_name'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_last_name'] = 1;
                    break;
                case 'nickname':
                    $templateOptions['pmsci_customer']['nickname'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_nickname'] = 1;
                    break;
                case 'description':
                    $templateOptions['pmsci_customer']['description'] = '{' . $element_name . '[1]}';
                    $templateOptions['is_update_description'] = 1;
                    break;
                default:
                    if ( in_array($element_value, $billing_keys)){
                        $templateOptions['pmsci_customer'][$element_value] = '{'. $element_name .'[1]}';
                        $bill_list[] = $element_value;
                    }
                    if ( in_array($element_value, $shipping_keys)){
                        $templateOptions['pmsci_customer'][$element_value] = '{'. $element_name .'[1]}';
                        $ship_list[] = $element_value;
                    }
                    break;
            }
        }

        /**
         * __get function.
         *
         * @access public
         * @param mixed $key
         * @return mixed
         */
        public function __get($key)
        {
            return $this->get($key);
        }

        /**
         * Get a session variable
         *
         * @param string $key
         * @param  mixed $default used if the session variable isn't set
         * @return mixed value of session variable
         */
        public function get($key, $default = null)
        {
            return isset($this->{$key}) ? $this->{$key} : $default;
        }
    }
}