<?php
/**
 * Print order header
 *
 * @package WooCommerce Print Invoice & Delivery Note/Templates
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="robots" content="noindex, nofollow, noarchive">
	<title><?php wcdn_document_title(); ?></title>

	<?php
		// wcdn_head hook.
		do_action( 'wcdn_head', wcdn_get_template_type() );
	if ( 'yes' === get_option( 'wcdn_rtl_invoice', 'no' ) ) {
		?>
		<style>
			body {
				direction: rtl;
			}
			.order-items dt,
			.order-items dd {
				float: right;
			}
			.content{
				text-align:right;	
			}
			th {
				text-align:right;
			}
			.company-address p {
				direction: ltr !important;
			}
			.billing-address address {
				direction: ltr !important;
			}
			.shipping-address address {
				direction: ltr !important;
			}
		</style>
		<?php
	}
	?>
</head>

<body class="<?php echo esc_attr( wcdn_get_template_type() ); ?>">

	<div id="container">

		<?php
			// wcdn_head hook.
			do_action( 'wcdn_before_page' );
		?>

		<div id="page">
