<?php
/**
 * Plugin Name: Webgility
 * Plugin URI: https://www.webgility.com/integrations/woocommerce
 * Description: Connect WooCommerce with Webgility Applications. To get started: 1) Click the "Activate" link to the left of this description. 2) Go to Webgility plugin settings. 3) Copy and paste the store module url into your Webgility application.
 * Version: 410
 * Author: Webgility
 * Author URI: https://www.webgility.com/integrations/woocommerce
 * License: GPLv2 or later
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
ini_set("display_errors", "Off");
error_reporting(E_ALL && ~E_NOTICE && '~E_STRICT');
define('eCC_VERSION', '3.6');
define('eCC_PLUGIN_URL', plugin_dir_url(__FILE__));
define('eCC_PLUGIN_DIR', plugin_dir_path(__FILE__));

/** If you hardcode a WP.com API key here, all key config screens will be hidden */
if (defined('WPCOM_API_KEY')) {
    $wpcom_api_key = constant('WPCOM_API_KEY');
} else {
    $wpcom_api_key = '';
}

// Make sure we don't expose any info if called directly
if (!function_exists('add_action')) {
    echo "Hi there!  I'm just a plugin, not much I can do when called directly.";
    exit;
}

/*
Webgility initialize function written for customisation use
 */
function webgility_init() {

}

/*
Define admin option fields
 */
class Webgility_Fields_Plugin {

    public function __construct() {
        // Hook into the admin menu
        add_action('admin_menu', array($this, 'create_plugin_settings_page'));
    }

    public function create_plugin_settings_page() {
        // Add the menu item and page
        $page_title = 'Webgility';
        $menu_title = 'Webgility';
        $capability = 'manage_options';
        $slug = 'webgility';
        $callback = array($this, 'plugin_settings_page_content');
        $icon = 'dashicons-admin-plugins';
        $position = 100;

        //add_menu_page( $page_title, $menu_title, $capability, $slug, $callback, $icon, $position );
        add_submenu_page('options-general.php', $page_title, $menu_title, $capability, $slug, $callback);
    }

    public function plugin_settings_page_content() {
        if (isset($_POST['updated']) && $_POST['updated'] === 'true') {
            $this->handle_form();
        } ?>
		<div class="wrap">
			<h2>Webgility Settings</h2>
			<form method="POST">
				<input type="hidden" name="updated" value="true" />
				<?php wp_nonce_field('webgility_update', 'webgility_form');?>
				<table class="form-table">
					<tbody>
						<tr>
							<th>
                                <label for="wgsaleprice">Store Module URL:</label>
                            </th>
							<td>
                                <div>
                                    <span id="webg_cl"><?php echo home_url() . "/wp-json/webgility/v1/api=true"; ?></span>
                                    <a style="margin-left: 10px;border: 1px solid;padding: 5px 8px;text-decoration: none;" href="javascript:void(0)" id="copyurl">Copy URL</a>
                                    <span class="copymsg" style="color: green; display: none;margin-left: 10px;">URL Copied!</span>
                                </div>
                            </td>
						</tr>
						<tr>
							<th>
                                <label for="order_number">Do you want to download orders with order number:</label>
                            </th>
							<td>
                                <input name="order_number" id="order_number_yes" type="checkbox" value="1" <?php if (get_option('webgility_order_number') == 1) { ?>checked="checked" <?php } ?>/><br/>
                                Only compatible with Sequential Order Numbers for WooCommerce plugin.<br/>
                                (Please make sure that there is no duplicate entries for orders and if there is any duplicate orders then delete the same.)
                            </td>
						</tr>
						<tr>
							<th>
                                <label for="wgsaleprice">Sync sale price:</label>
                            </th>
							<td>
                                <input name="wgsaleprice" id="wgsaleprice_yes" type="checkbox" value="1" <?php if (get_option('webgility_wgsaleprice') == 1) { ?>checked="checked" <?php } ?>/>
                            </td>
						</tr>
					</tbody>
				</table>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button button-primary" value="Save">
				</p>
			</form>
		</div>
	<?php }

    public function handle_form() {
        if (!isset($_POST['webgility_form']) || !wp_verify_nonce($_POST['webgility_form'], 'webgility_update')) { ?>
			<div class="error">
			   <p>Sorry, your nonce was not correct. Please try again.</p>
			</div>
		<?php exit;
		} else {
            update_option('webgility_order_number', empty($_POST['order_number']) ? 0 : 1);
            update_option('webgility_wgsaleprice', empty($_POST['wgsaleprice']) ? 0 : 1);
            ?>
			<div class="updated">
				<p>Your fields were saved!</p>
			</div>
		<?php }
    }
}
new Webgility_Fields_Plugin();

/*
Define rest endpoint for connection with Webgility Software
 */
add_action('rest_api_init', function () {

    register_rest_route('webgility/v1', '/api=true', array(
        'methods' => 'GET',
        'callback' => 'webgility_connection_add',
        'permission_callback' => '__return_true',
    ));

    register_rest_route('webgility/v1', '/api=true', array(
        'methods' => 'POST',
        'callback' => 'webgility_connection',
        'permission_callback' => '__return_true',
    ));

});

/*
Information page which shows the required variable for the module.
 */
function webgility_connection_add($request) {
    if (!isset($_REQUEST['request'])) {
        // Set the content type to 'text/html'
        header('Content-Type: text/html; charset=utf-8');

        // HTML content
        include_once 'webgility-config.php';

        echo "<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'><html xmlns='http://www.w3.org/1999/xhtml' xml:lang='en' lang='en'><head> <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /> <meta http-equiv='imagetoolbar' content='no' /> <title>Webgility Store Module</title> <meta name='DATE' content='08/03/2007' /> <link rel='icon' href='http://www.webgility.com/favicon.png' type='x-icon' /> <style> .red_tr {background-color:#F7B7B7; color:#000000; font-weight:100; padding:5px 5px 5px 5px; margin-top:10px; text-align:left;} .red_tr a {color:#F7B7B7;} .green_tr {padding:5px 5px 5px 5px; text-align:left; font-size: 12px;} .green_tr a {color:#000000;} .red_btn_submit {background-color:#FF6600; color:#FFFFFF; font-weight:100; padding:2px 2px 2px 2px;} .error {color:#CC0000; font-weight:100; padding:2px;} .success {color:#009933; font-weight:100; padding:2px;} #footer {width:100%; text-align:center; color:#CCCCCC;} #wrap {text-align:center; padding:10px; font-size:16px; color:#000; font-weight: bold;} #centerdiv {width:700px; overflow:hidden; text-align:center; position:static; vertical-align:middle;} #information {text-align:left; background-color: #CCC; padding: 5px;} </style> </head><body id='innerpage-bg' ><div id='wrap'>Webgility Store Module (" . $storeMduleVersion . ")</div><div id='content' align='center'><div id='centerdiv'><div class='green_tr'>Compatible with WooCommerce version: " . $cartCompitableVersion . "</div>";

        if (extension_loaded("curl") && extension_loaded("json") && extension_loaded("mcrypt") && phpversion() > 5) {
            echo '<div id="information">Extensions required</div>';
        } else {
            echo '<div id="information">Extensions required</div>';
        }

        if (extension_loaded("curl")) {
            echo '<div class="green_tr">PHP Curl &nbsp;:&nbsp;<span style=" color:#006600; padding:55px;" > Ok </span></div>';
        } else {
            echo '<div class="red_tr">PHP Curl &nbsp;:&nbsp; Required. </div>';
        }

        if (extension_loaded("json")) {
            echo '<div class="green_tr">PHP Json &nbsp;:&nbsp; <span style=" color:#006600; padding:50px;" > Ok </span> </div>';
        } else {
            echo '<div class="red_tr">PHP Json &nbsp;:&nbsp; Required. </div>';
        }

        if (extension_loaded("mcrypt")) {
            echo '<div class="green_tr">PHP Mcrypt &nbsp;:&nbsp; <span style=" color:#006600; padding:40px;" > Ok </span> </div>';
        }

        if (extension_loaded("openssl")) {
            echo '<div class="green_tr">PHP Openssl &nbsp;:&nbsp; <span style=" color:#006600; padding:40px;" > Ok </span> </div>';
        } else {
            echo '<div class="red_tr">PHP Openssl &nbsp;:&nbsp; Required. </div>';
        }

        if (extension_loaded("iconv")) {
            echo '<div class="green_tr">PHP Iconv &nbsp;:&nbsp;<span style=" color:#006600; padding:55px;" > Ok </span></div>';
        } else {
            echo '<div class="red_tr">PHP Iconv &nbsp;:&nbsp; Required. </div>';
        }

        if (phpversion() > 5) {
            echo '<div class="green_tr">PHP Version ' . phpversion() . ' &nbsp;:&nbsp; <span style=" color:#006600"> Ok </span> </div>';
        } else {
            echo '<div class="green_tr">PHP Version ' . phpversion() . ' &nbsp;:&nbsp; Must be greater than PHP 5.0 </div>';
        }

        echo '<div id="information">Environment details</div>';

        if ($globalSSLmsg && $globalSSLmsg != '') {
            echo '<div class="green_tr"><strong>' . $globalSSLmsg . '</strong></div>';
        }

        echo '<div class="green_tr">Memory Limit: ' . "(" . ini_get("memory_limit") . ") (Recommend at least 128MB)</div><div>&nbsp;</div>";
        echo '</div>';
        echo '</div>';
        echo '<div id="footer">';
        echo '<p>copyright 2007-' . date('Y') . ' &copy; webgility Inc. all rights reserved.</p></div></body></html>';

        // Stop further execution
        exit;
    }
}

function webgility_connection($request) {
    $creds = array();
    $headers = getallheaders();

    global $woocommerce;
    $version = $woocommerce->version;
    if ($version > '2.2.0') {
        require_once 'lib/D.woocommerce.php';
    } else {
        require_once 'lib/D.woocommerce1.php';
    }
}

function fs_get_wp_config_path() {
    $base = dirname(__FILE__);
    $path = false;

    if (@file_exists(dirname(dirname($base)) . "/wp-config.php")) {
        $path = dirname(dirname($base)) . "/wp-config.php";
    } else if (@file_exists(dirname(dirname(dirname($base))) . "/wp-config.php")) {
        $path = dirname(dirname(dirname($base))) . "/wp-config.php";
    } else {
        $path = false;
    }

    if ($path != false) {
        $path = str_replace("\\", "/", $path);
    }

    return $path;
}

add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wg_settings_link', 10, 5);
function wg_settings_link($actions, $plugin_file) {
    static $plugin;

    if (!isset($plugin)) {
        $plugin = plugin_basename(__FILE__);
    }

    if ($plugin == $plugin_file) {
        $settings = array('settings' => '<a href="options-general.php?page=webgility">' . __('Settings', 'webgility') . '</a>');
        $actions = array_merge($settings, $actions);
    }

    return $actions;
}

function load_wgcustom_script($hook) {
    wp_enqueue_script(
        'custom_js_script', // Handle
        plugins_url('/assets/js/wg_custom.js', __FILE__), // Path to file
        array('jquery') // Dependancies
    );
}
add_action('admin_enqueue_scripts', 'load_wgcustom_script', 2000);