<?php
/*
===================================
© Copyright Webgility LLC 2007-2024
----------------------------------------
This file and the source code contained herein are the property of Webgility LLC
and are protected by United States copyright law. All usage is restricted as per
the terms & conditions of Webgility License Agreement. You may not alter or remove
any trademark, copyright or other notice from copies of the content.

The code contained herein may not be reproduced, copied, modified or redistributed in any form
without the express written consent by an officer of Webgility LLC.

WooCommerce plug in version : 9.0.2
===================================
*/

ini_set("display_errors", "Off");
error_reporting(E_ALL && ~E_NOTICE && '~E_STRICT');

require_once 'D.WgCommon.php';

# Added for removing memory exhausted  problem of service file
if (((int) str_replace("M", "", ini_get("memory_limit"))) < 128) {
    ini_set("memory_limit", "128M");
}

#download orders with order number-
if (get_option('webgility_order_number')) {
    unset($download_order_number);
    $download_order_number = true;
}

#saleprice setting-
if (get_option('webgility_wgsaleprice')) {
    unset($synch_sale_price);
    $synch_sale_price = true;
}

class Webgility_Ecc_WP extends WgCommon {

    public function auth_user($username, $password) {

        global $sql_tbl;

        add_filter('authenticate', 'wp_authenticate_username_password', 20, 3);

        #Fixed -  Invalid password. Authorization failed error.
        if (preg_match('/\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/si', $username)) {
            $email = wp_authenticate_email_password('WP_User', $username, $email, $password);
        } else {
            $user = wp_authenticate_username_password('WP_User', $username, $password);
        }
        #Fixed -  Invalid password. Authorization failed error.

        $WgBaseResponse = new WgBaseResponse();

        $plugins = get_option('active_plugins');
        $required_plugin = 'webgility_wp_woocommerce/webgility_wp_woocommerce.php';
        if (!in_array($required_plugin, $plugins)) {
            $WgBaseResponse->setStatusCode('1');
            $WgBaseResponse->setStatusMessage('Plugin not activated please activate plugin before using it.');
            return $this->response($WgBaseResponse->getBaseResponse());
            exit;
        }

        try {
            if (isset($user->errors['invalid_username'])) {
                if (is_array($user->errors['invalid_username'])) {
                    $WgBaseResponse->setStatusCode('1');
                    $WgBaseResponse->setStatusMessage('Invalid login. Authorization failed');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } elseif (isset($user->errors['incorrect_password'])) {
                if (is_array($user->errors['incorrect_password'])) {
                    $WgBaseResponse->setStatusCode('2');
                    $WgBaseResponse->setStatusMessage('Invalid password. Authorization failed');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } elseif (isset($email->errors['invalid_email'])) {
                if (is_array($email->errors['invalid_email'])) {
                    $WgBaseResponse->setStatusCode('1');
                    $WgBaseResponse->setStatusMessage('Invalid login. Authorization failed');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } elseif (isset($email->errors['incorrect_password'])) {
                if (is_array($email->errors['incorrect_password'])) {
                    $WgBaseResponse->setStatusCode('2');
                    $WgBaseResponse->setStatusMessage('Invalid password. Authorization failed');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } else {
                return 0;
            }
        } catch (Exception $e) {
            $WgBaseResponse->setStatusCode('1');
            $WgBaseResponse->setStatusMessage('Invalid login. Authorization failed');
            return $this->response($WgBaseResponse->getBaseresponse());
            exit;
        }
    }

    #***********************************************************
    # Function to check the admin username and password and also the Webgility Version and Store Version
    public function checkAccessInfo($username, $password) {

        global $version, $cartCompitableVersion, $minCartVersion;

        $status = $this->auth_user($username, $password);

        if ($status != '0') {
            return $status;
        }

        $WgBaseResponse = new WgBaseResponse();
        $WgBaseResponse->setStatusCode('0');

        $code = "0";
        $message = "Successfully connected to your online store.";
        $responseArray['StatusCode'] = $code;

        if ($version != "0") {
            if (version_compare($version, $minCartVersion, '<') || version_compare($version, $cartCompitableVersion, '>')) {
                $WgBaseResponse->setStatusMessage($message . " However, your store version is " . $version . " which hasn't been fully tested with webgility. If you'd still like to continue, click OK to continue or contact Webgility to confirm compatibility.");
            } else {
                $WgBaseResponse->setStatusMessage($message);
            }
        } else {
            $WgBaseResponse->setStatusMessage($message . " However, webgility is unable to detect your store version. If you'd still like to continue, click OK to continue or contact Webgility to confirm compatibility.");
        }

        return $this->response($WgBaseResponse->getBaseResponse());
    } // Check AccessInfo

    #
    # Returns the Company Info of the Store
    #
    public function getCompanyInfo($username, $password) {

        global $config;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $adminEmail = htmlspecialchars(get_option('admin_email'), ENT_NOQUOTES);
        $the_user = get_user_by('email', $adminEmail);
        $the_user_id = $the_user->ID;
        $profileDetails = get_user_meta($the_user_id);

        if (isset($adminEmail) && $adminEmail != '') {
            $companyEmail = $adminEmail;
        } else {
            $companyEmail = $profileDetails['billing_email'][0];
        }

        $companyPhone = ($profileDetails['billing_phone'][0]) ? $profileDetails['billing_phone'][0] : htmlspecialchars($config['Company']['company_phone'], ENT_NOQUOTES);
        // $companyPostcode = ($profileDetails['billing_postcode'][0])?$profileDetails['billing_postcode'][0]:htmlspecialchars(get_option('woocommerce_store_postcode'), ENT_NOQUOTES);
        $companyPostcode = (htmlspecialchars(get_option('woocommerce_store_postcode'), ENT_NOQUOTES)) ? htmlspecialchars(get_option('woocommerce_store_postcode'), ENT_NOQUOTES) : $profileDetails['billing_postcode'][0];

        $CompanyInfo = new WG_CompanyInfo();
        $CompanyInfo->setStatusCode('0');
        $CompanyInfo->setStatusMessage('All Ok');
        $CompanyInfo->setStoreName(esc_attr(get_option('blogname')));
        $CompanyInfo->setAddress(htmlspecialchars(get_option('woocommerce_store_address'), ENT_NOQUOTES));
        $CompanyInfo->setAddress2(htmlspecialchars(get_option('woocommerce_store_address_2'), ENT_NOQUOTES));
        $CompanyInfo->setcity(htmlspecialchars(get_option('woocommerce_store_city'), ENT_NOQUOTES));
        // $CompanyInfo->setState(htmlspecialchars($region, ENT_NOQUOTES)?htmlspecialchars($region, ENT_NOQUOTES):htmlspecialchars(get_option('base_city'), ENT_NOQUOTES));
        $CompanyInfo->setState(htmlspecialchars(get_option('base_city'), ENT_NOQUOTES) ? htmlspecialchars(get_option('base_city'), ENT_NOQUOTES) : htmlspecialchars($region, ENT_NOQUOTES));
        // $CompanyInfo->setCountry(htmlspecialchars(get_option('woocommerce_default_country'), ENT_NOQUOTES));
        $CompanyInfo->setZipcode($companyPostcode);
        $CompanyInfo->setPhone($companyPhone);
        $CompanyInfo->setFax(htmlspecialchars($config['Company']['company_fax'], ENT_NOQUOTES) ? htmlspecialchars($config['Company']['company_fax'], ENT_NOQUOTES) : $companyPhone);
        $CompanyInfo->setEmail($companyEmail);
        $CompanyInfo->setWebsite(htmlspecialchars(get_option('home'), ENT_NOQUOTES));

        $currTimeZoneOffset = get_option('gmt_offset');
        $currTimeZoneName = get_option('timezone_string');
        $CompanyInfo->setTimeZoneffest($currTimeZoneOffset);
        $CompanyInfo->setTimezoneName($currTimeZoneName);

        $state_country = get_option('woocommerce_default_country');
        $state_country = explode(":", $state_country);
        // $companyState = ($profileDetails['billing_state'][0])?$profileDetails['billing_state'][0]:htmlspecialchars($state_country[1], ENT_NOQUOTES);
        $companyState = (htmlspecialchars($state_country[1], ENT_NOQUOTES)) ? htmlspecialchars($state_country[1], ENT_NOQUOTES) : $profileDetails['billing_state'][0];
        $companyCountry = ($profileDetails['billing_country'][0]) ? $profileDetails['billing_country'][0] : htmlspecialchars($state_country[0], ENT_NOQUOTES);

        $CompanyInfo->setState($companyState);
        $CompanyInfo->setCountry($companyCountry);

        return $this->response($CompanyInfo->getCompanyInfo());
    } // GetCompanyInfo

    #
    # Function returns All the Payment Methods used by the store
    #
    public function getPaymentMethods($username, $password) {

        global $woocommerce;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $PaymentMethods = new WG_PaymentMethods();
        $PaymentMethods->setStatusCode('0');
        $PaymentMethods->setStatusMessage('All Ok');

        $payment_gateways = $woocommerce->payment_gateways;
        if ($payment_gateways) {
            $i = 1;
            $payment = $payment_gateways->payment_gateways;
            foreach ($payment as $k => $gateway) {
                $PaymentMethod = new WG_PaymentMethod();
                $PaymentMethod->setMethodId($i);
                $PaymentMethod->setMethod($gateway->title ? $gateway->title : "");
                $PaymentMethod->setDetail($gateway->description ? $gateway->description : "");
                $PaymentMethods->setPaymentMethods($PaymentMethod->getPaymentMethod());
                $i++;
            }
        }

        return $this->response($PaymentMethods->getPaymentMethods());
    } // getPaymentMethods

    #
    # Returns all the shipping methods used by the store
    #
    public function getShippingMethods($username, $password) {

        global $woocommerce;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $WgBaseResponse = new WgBaseResponse();

        $ShippingMethods = new WG_ShippingMethods();
        $ShippingMethods->setStatusCode('0');
        $ShippingMethods->setStatusMessage('All Ok');

        $shipping_methods = $woocommerce->shipping->load_shipping_methods();
        if (is_array($shipping_methods)) {
            foreach ($shipping_methods as $key => $module) {
                $ShippingMethod = new WG_ShippingMethod();
                $ShippingMethod->setCarrier($module->method_title);
                $ShippingMethod->setIsActive(true);
                $ShippingMethod->setMethods($module->method_title);
                $ShippingMethods->setShippingMethods($ShippingMethod->getShippingMethod());
            }
        }

        return $this->response($ShippingMethods->getShippingMethods());
    }

    #
    # function to return the store Category list so synch with QB inventory
    #
    public function getCategory($username, $password) {

        global $woocommerce;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Categories = new WG_Categories();
        $Categories->setStatusCode('0');
        $Categories->setStatusMessage('All Ok');

        $categories_arr = get_terms('product_cat', 'orderby=name&hide_empty=0');
        if ($categories_arr) {
            foreach ($categories_arr as $categories) {
                $Category = new WG_Category();
                $Category->setCategoryID($categories->term_id);
                $Category->setCategoryName($categories->name);
                $Category->setParentID($categories->parent);
                $Categories->setCategories($Category->getCategory());
            }
        }

        return $this->response($Categories->getCategories());
    } // Category

    #
    # function to return the store tax list so synch with QB inventory
    #
    public function getTaxes($username, $password) {

        global $woocommerce;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Taxes = new WG_Taxes();
        $Taxes->setStatusCode('0');
        $Taxes->setStatusMessage('All Ok');

        $tax_classes = array_filter(array_map('trim', explode("\n", get_option('woocommerce_tax_classes'))));
        $classes_options = array();
        $classes_options['standard-rate'] = __('Standard', 'woocommerce');
        if ($tax_classes) {
            foreach ($tax_classes as $class) {
                $classes_options[sanitize_title($class)] = $class;
            }
        }

        if ($classes_options) {
            $i = 0;
            foreach ($classes_options as $key => $classes) {
                $Tax = new WG_Tax();
                $Tax->setTaxID($key);
                if ($key == "") {
                    $Tax->setTaxName($classes . ' Rate');
                } else {
                    $Tax->setTaxName($classes);
                }
                $Taxes->setTaxes($Tax->getTax());
                $i++;
            }

        }

        return $this->response($Taxes->getTaxes());
    } // getTaxes

    # retrive all order status
    public function getOrderStatus($username, $password) {

        global $woocommerce;
        $version = $woocommerce->version;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $OrderStatuses = new WG_OrderStatuses();
        $OrderStatuses->setStatusCode('0');
        $OrderStatuses->setStatusMessage('All Ok');

        if ($version > "2.2.0") {
            $orderStatus = wc_get_order_statuses();
            foreach ($orderStatus as $id => $name) {
                $OrderStatus = new WG_OrderStatus();
                $OrderStatus->setOrderStatusID($id);
                #Fixed - Order status download issue.
                $OrderStatus->setOrderStatusName(htmlspecialchars_decode($name));
                $OrderStatuses->setOrderStatuses($OrderStatus->getOrderStatus());
            }
        } else {
            $orderStatus = (array) get_terms('shop_order_status', array('hide_empty' => 0, 'orderby' => 'id'));
            foreach ($orderStatus as $statusdata) {
                $OrderStatus = new WG_OrderStatus();
                $OrderStatus->setOrderStatusID($statusdata->term_id);
                $OrderStatus->setOrderStatusName($statusdata->name);
                $OrderStatuses->setOrderStatuses($OrderStatus->getOrderStatus());
            }
        }

        return $this->response($OrderStatuses->getOrderStatuses());
    } //getOrderStatus

    #
    # function to return the store item list so synch with QB inventory
    #
    public function getItems($username, $password, $start_item_no = 0, $limit = 500) {

        global $wpdb, $synch_sale_price, $version;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status !== 0) {
            return $status;
        }

        $Items = new WG_Items();
        $Items->setStatusCode('0');
        $Items->setStatusMessage('All Ok');

        $items_query_raw = '';

        if (isset($others[0]['ItemCode']) && trim($others[0]['ItemCode']) != '') {
            // $items_query_raw = " AND pm.meta_value ='".trim($others[0]['ItemCode'])."' ";
            $items_query_raw = " AND pm.meta_value in (" . trim($others[0]['ItemCode']) . ") ";
        }

        $sql_total = "SELECT ID FROM $wpdb->posts p INNER JOIN $wpdb->postmeta pm ON p.ID = pm.post_id WHERE p.post_type = 'product' AND p.post_status='publish' group by p.ID " . $items_query_raw . " ORDER BY p.post_date_gmt";

        $total_record = count($wpdb->get_results($sql_total));
        $Items->setTotalRecordFound($total_record ? $total_record : '0');

        $sql = "SELECT ID, post_title, post_content FROM $wpdb->posts p INNER JOIN $wpdb->postmeta pm ON p.ID = pm.post_id WHERE post_type = 'product' AND post_status='publish' group by p.ID " . $items_query_raw . " ORDER BY post_date_gmt ASC limit $start_item_no, $limit";
        $product_list = $wpdb->get_results($sql);

        if ($product_list) {
            $weight_unit = get_option('woocommerce_weight_unit');

            foreach ($product_list as $iInfo) {
                $product = get_metadata('post', $iInfo->ID);
                // $product = new woocommerce_get_product_terms( $iInfo->ID );

                $Item = new WG_Item();

                $Item->setItemID($iInfo->ID);
                $Item->setItemCode($product['_sku'][0]);
                $Item->setSku($product['_sku'][0]);
                $Item->setItemDescription(strip_tags(html_entity_decode($iInfo->post_title)));
                $Item->setItemShortDescr(strip_tags(html_entity_decode($iInfo->post_content)));
                // $Item->setManufacturer($manufacturer['manufacturer']);
                $Item->setQuantity($product['_stock'][0]);

                $to_unit = 'lbs';
                $weight_in_lbs = wc_get_weight($product['_weight'][0], $to_unit);

                $Item->setWeight($weight_in_lbs);
                $Item->setLowQtyLimit('');
                $Item->setFreeShipping('');
                $Item->setDiscounted('');
                $Item->setShippingFreight('');

                $Item->setWeight_Symbol($weight_unit);
                $weight_symbol_grams = '453.6';
                $Item->setWeight_Symbol_Grams($weight_symbol_grams);

                if ($product['_tax_status'][0] == 'none') {
                    $taxexempt = 'N';
                } else {
                    $taxexempt = 'Y';
                }
                $Item->setTaxExempt($taxexempt);

                $cat_array = $wpdb->get_results("SELECT t.term_id ,t.name, t.slug, tt.parent FROM $wpdb->terms AS t INNER JOIN $wpdb->term_taxonomy AS tt ON tt.term_id = t.term_id INNER JOIN $wpdb->term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id INNER JOIN $wpdb->posts AS p ON p.ID = tr.object_id  WHERE tt.taxonomy IN ('product_cat') AND p.post_type= 'product' AND p.ID = $iInfo->ID ORDER BY p.ID ASC", ARRAY_A);
                foreach ($cat_array as $catid) {
                    $catArray = [];
                    $catArray['CategoryId'] = $catid['term_id'];
                    $catArray['CategoryName'] = $catid['name'];
                    $catArray['ParentId'] = $catid['parent'];
                    $Item->setCategories($catArray);
                }

                // $iVariants = $xmlResponse->createTag("ItemVariants", array(), '',$itemNode);
                $Variants = new WG_Variants();

                /* Fixed $ sign issue item price field */
                if (!empty($product['_sale_price'][0])) {
                    $product['_sale_price'][0] = str_replace('$', '', $product['_sale_price'][0]);
                }

                if (!empty($product['_regular_price'][0])) {
                    $product['_regular_price'][0] = str_replace('$', '', $product['_regular_price'][0]);
                }
                #Fixed - Variant items price are not downloading from Woocommerce Store.
                /* Fixed $ sign issue item price field */
                if (version_compare(WC_VERSION, '2.0', '>')) {
                    #Fixed - Variant items price are not downloading from Woocommerce Store.
                    $varient_product_class = new WC_Product_Variable($iInfo->ID);
                    $product_variation = $varient_product_class->has_child();
                } else {
                    $product_variation = $product['_product_attributes'];
                    $variation_list = unserialize($product_variation[0]);
                }

                if ($product_variation) {
                    if ($synch_sale_price == true) {
                        $Item->setUnitPrice('0.00');
                        $Item->setListPrice('0.00');
                    } else {
                        $Item->setUnitPrice('0.00');
                        $Item->setListPrice('0.00');
                    }
                } else {
                    if ($synch_sale_price == true) {
                        if ((!empty($product['_sale_price'][0]) || $product['_sale_price'][0] != '') && (!is_infinite($product['_sale_price'][0]) || !is_nan($product['_sale_price'][0]))) {

                            $Item->setUnitPrice(str_replace(',', '', $product['_sale_price'][0]));

                        } else if ((!empty($product['_regular_price'][0]) || $product['_regular_price'][0] != '') && (!is_infinite($product['_regular_price'][0]) || !is_nan($product['_regular_price'][0]))) {

                            $Item->setUnitPrice(str_replace(',', '', $product['_regular_price'][0]));

                        } else {
                            $Item->setUnitPrice('0.00');
                        }

                        $Item->setListPrice('0.00');
                    } else {
                        $regularprice = substr_count($product['_regular_price'][0], '.');
                        if ($regularprice > 1) {
                            continue;
                        }

                        if (is_float($product['_regular_price'][0])) {
                            $Item->setUnitPrice('0.00');
                        } else {
                            $Item->setUnitPrice($product['_regular_price'][0]);
                        }

                        $Item->setListPrice('0.00');
                    }
                }

                if ($product_variation) {
                    $children_products = &get_children('post_parent=' . $iInfo->ID . '&post_type=product_variation');

                    foreach ($children_products as $ioInfo) {
                        $VariantArray = [];

                        #Fixed - Variant items price are not downloading from Woocommerce Store.
                        if (version_compare(WC_VERSION, '2.0', '>')) {
                            #Fixed - Variant items price are not downloading from Woocommerce Store.
                            $_product = get_metadata('post', $ioInfo->ID);
                            $VariantArray['ItemCode'] = $_product['_sku'][0];
                            $VariantArray['VarientID'] = $ioInfo->ID;

                            if ($_product['_stock'][0] > 0) {
                                $VariantArray['Quantity'] = $_product['_stock'][0];
                            } else {
                                $VariantArray['Quantity'] = "0.0";
                            }

                            if ($synch_sale_price == true) {
                                if ((!empty($_product['_sale_price'][0]) || $_product['_sale_price'][0] != '') && (!is_infinite($_product['_sale_price'][0]) || !is_nan($_product['_sale_price'][0]))) {

                                    $VariantArray['UnitPrice'] = str_replace(',', '', $_product['_sale_price'][0]);

                                } else if ((!empty($_product['_regular_price'][0]) || $_product['_regular_price'][0] != '') && (!is_infinite($_product['_regular_price'][0]) || !is_nan($_product['_regular_price'][0]))) {

                                    $VariantArray['UnitPrice'] = $_product['_regular_price'][0];

                                } else {
                                    $Item->setUnitPrice('0.00');
                                }
                            } else {
                                $regularvprice = substr_count($_product['_regular_price'][0], '.');

                                if ($regularvprice > 1) {
                                    continue;
                                }

                                if ($_product['_regular_price'][0] > 0) {
                                    $VariantArray['UnitPrice'] = str_replace(',', '', $_product['_regular_price'][0]);
                                } else {
                                    $VariantArray['UnitPrice'] = "0.0";
                                }
                            }

                            $to_unit = 'lbs';
                            $Vweight_in_lbs = wc_get_weight($_product['_weight'][0], $to_unit);
                            $VariantArray['Weight'] = $Vweight_in_lbs ? $Vweight_in_lbs : "0.0";
                            $Item->setItemVariants($VariantArray);
                        } else {
                            $variation = new WC_Product_Variation($ioInfo->ID);
                            $VariantArray['ItemCode'] = $variation->sku;
                            $VariantArray['VarientID'] = $ioInfo->ID;
                            $VariantArray['Quantity'] = $variation->stock ? $variation->stock : "0.0";
                            $VariantArray['UnitPrice'] = $variation->sale_price ? $variation->sale_price : "0.0";

                            $to_unit = 'lbs';
                            $Vweight_in_lbs = wc_get_weight($variation->weight, $to_unit);
                            $VariantArray['Weight'] = $Vweight_in_lbs ? $Vweight_in_lbs : "0.0";
                            $Item->setItemVariants($VariantArray);
                        }
                    }
                }

                $Items->setItems($Item->getItem());
            } // end items
        }

        return $this->response($Items->getItems());
    } // getItems

    /**
     * This is one part of the code that displays the variation combination forms in the add and edit product pages.
     * If this fails to find any data about the variation combinations, it runs "variations_add_grid_view" instead
     */
    public function variations_grid_view($product_id, $variation_values = null) {

        global $wpdb;

        $product_id = (int) $product_id;
        $product_data = $wpdb->get_row("SELECT price, quantity_limited FROM " . WPSC_TABLE_PRODUCT_LIST . " WHERE id IN ('{$product_id}') LIMIT 1", ARRAY_A);
        $product_price = $product_data['price'];

        $associated_variations = $wpdb->get_results("SELECT * FROM " . WPSC_TABLE_VARIATION_ASSOC . " WHERE type IN ('product') AND associated_id = '{$product_id}' ORDER BY id ASC", ARRAY_A);
        $variation_count = count($associated_variations);
        if ($variation_count > 0) {
            foreach ((array) $associated_variations as $key => $associated_variation) {
                $variation_id = (int) $associated_variation['variation_id'];

                $excluded_values = $wpdb->get_col("SELECT value_id FROM " . WPSC_TABLE_VARIATION_VALUES_ASSOC . " WHERE product_id IN('{$associated_variation['associated_id']}') AND variation_id IN ('{$variation_id}') AND visible IN ('1')");

                $included_value_sql = "AND b{$variation_id}.value_id  IN('" . implode("','", $excluded_values) . "')";

                // generate all the various bits of SQL to bind the tables together
                $join_selected_cols[] = "b{$variation_id}.value_id AS value_id{$variation_id}";
                $join_tables[] = "" . WPSC_TABLE_VARIATION_COMBINATIONS . " AS b{$variation_id}";
                $join_on[] = "a.id = b{$variation_id}.priceandstock_id";
                $join_conditions[] = "b{$variation_id}.variation_id = '{$variation_id}' AND b{$variation_id}.all_variation_ids IN (':all_variation_ids:') $included_value_sql";
                $join_order[] = "value_id{$variation_id} ASC";

                // also store the columns in which the value ID's are, because we need them later
                $table_columns[] = "value_id{$variation_id}";
                $selected_variations[] = $variation_id;
                $get_variation_names = $wpdb->get_results("SELECT id, name FROM " . WPSC_TABLE_VARIATION_VALUES . " WHERE variation_id = '{$variation_id}'", ARRAY_A);
                foreach ((array) $get_variation_names as $get_variation_name) {
                    $variation_names[$get_variation_name['id']] = $get_variation_name['name'];
                }
            }

            // implode the SQL statment segments into bigger segments
            $join_selected_cols = implode(", ", $join_selected_cols);
            $join_tables = implode(" JOIN ", $join_tables);
            $join_on = implode(" AND ", $join_on);
            $join_conditions = implode(" AND ", $join_conditions);
            $join_order = implode(", ", $join_order);
            asort($selected_variations);

            $all_variation_ids = implode(",", $selected_variations);
            $join_conditions = str_replace(":all_variation_ids:", $all_variation_ids, $join_conditions);

            // Assemble and execute the SQL query
            $associated_variation_values = $wpdb->get_results("SELECT a.*, {$join_selected_cols} FROM  " . WPSC_TABLE_VARIATION_PROPERTIES . " AS a JOIN {$join_tables} ON {$join_on} WHERE a.product_id = '$product_id' AND {$join_conditions} ORDER BY {$join_order}", ARRAY_A);

            // if there are no associated variations, run this function instead
            if (count($associated_variation_values) < 1) {
                $price = $wpdb->get_var("SELECT price FROM " . WPSC_TABLE_PRODUCT_LIST . " WHERE id ='{$product_id}' LIMIT 1");
                return variations_add_grid_view((array) $selected_variations, $variation_values, $price, $limited_stock, $product_id);
            }

            $br = 0;
            foreach ((array) $associated_variation_values as $key => $associated_variation_row) {
                // generate the variation name and ID arrays
                $associated_variation_names = array();
                $associated_variation_ids = array();

                foreach ((array) $table_columns as $table_column) {
                    $associated_variation_ids[] = $associated_variation_row[$table_column];
                    $associated_variation_names[] = $variation_names[$associated_variation_row[$table_column]];
                }

                $group_defining_class = '';
                if ($associated_variation_ids[0] != $associated_variation_values[$key + 1]["value_id{$selected_variations[0]}"]) {
                    $group_defining_class = "group_boundary";
                }

                $previous_row_id = $associated_variation_ids[0];

                // Implode them into a comma seperated string
                $associated_variation_names = stripslashes(implode(", ", (array) $associated_variation_names));
                $associated_variation_ids = implode(",", (array) $associated_variation_ids);
                $variation_settings_uniqueid = $product_id . "_" . str_replace(",", "_", $associated_variation_ids);

                // Format the price nicely
                if (is_numeric($associated_variation_row['price'])) {
                    $product_price = number_format($associated_variation_row['price'], 2, '.', '');
                }

                $file_checked = '';
                if ((int) $associated_variation_row['file'] == 1) {
                    $file_checked = "checked='checked'";
                }

                $var[$br]['name'] = $associated_variation_names;
                $var[$br]['stock'] = $associated_variation_row['stock'];
                $var[$br]['price'] = $product_price;
                $var[$br]['optionid'] = $associated_variation_ids;

                $br++;
            }
        }

        return $var;
    }

    public function variations_add_grid_view($variations, $variation_values = null, $default_price = null, $limited_stock = true, $product_id = 0) {

        global $wpdb;

        $variation_count = count($variations);
        if ($variation_count < 1) {
            return "";
            exit();
        }

        $stock_column_state = '';
        if ($limited_stock == false) {
            $stock_column_state = " style='display: none;'";
        }

        if ((float) $default_price == 0) {
            $default_price = 0;
        }
        $default_price = number_format($default_price, 2, '.', '');

        // Need to join the wp_variation_values variation_values table to itself multiple times with no condition for joining, resulting in every combination of values being extracted
        foreach ((array) $variations as $variation) {
            $variation = (int) $variation;
            $excluded_value_sql = '';

            if ($product_id > 0) {
                $included_values = $wpdb->get_col("SELECT value_id FROM " . WPSC_TABLE_VARIATION_VALUES_ASSOC . " WHERE product_id IN('{$product_id}') AND variation_id IN ('{$variation}') AND visible IN ('1')");
                $included_values_sql = "AND a{$variation}.id IN('" . implode("','", $included_values) . "')";
            } else if (count($variation_values) > 0) {
                $included_values_sql = "AND a{$variation}.id IN('" . implode("','", $variation_values) . "')";
            }

            // generate all the various bits of SQL to bind the tables together
            $join_selected_cols[] = "a{$variation}.id AS id_{$variation}, a{$variation}.name AS name_{$variation}";
            $join_tables[] = "" . WPSC_TABLE_VARIATION_VALUES . " AS a{$variation}";
            $join_conditions[] = "a{$variation}.variation_id = '{$variation}' $included_values_sql";
        }

        // implode the SQL statment segments into bigger segments
        $join_selected_cols = implode(", ", $join_selected_cols);
        $join_tables = implode(" JOIN ", $join_tables);
        $join_conditions = implode(" AND ", $join_conditions);

        // Assemble and execute the SQL query
        $associated_variation_values = $wpdb->get_results("SELECT {$join_selected_cols} FROM {$join_tables} WHERE {$join_conditions}", ARRAY_A);

        $variation_sets = array();
        $i = 0;
        foreach ((array) $associated_variation_values as $associated_variation_value_set) {
            foreach ($variations as $variation) {
                $value_id = $associated_variation_value_set["id_$variation"];
                $name_id = $associated_variation_value_set["name_$variation"];
                $variation_sets[$i][$value_id] = $name_id;
            }

            $i++;
        }

        $br = 0;
        foreach ((array) $variation_sets as $key => $variation_set) {
            $variation_names = implode(", ", $variation_set);
            $variation_id_array = array_keys((array) $variation_set);
            $variation_ids = implode(",", $variation_id_array);
            $variation_settings_uniqueid = "0_" . str_replace(",", "_", $variation_ids);

            $group_defining_class = '';

            $next_id_set = array_keys((array) $variation_sets[$key + 1]);
            if ($variation_id_array[0] != $next_id_set[0]) {
                $group_defining_class = "group_boundary";
            }

            $var[$br]['name'] = $variation_names;
            $var[$br]['optionid'] = $variation_ids;

            $br++;
        }

        return $var;
    }

    #
    # function to return the store Manufacturer list so synch with QB inventory
    #
    public function getManufacturers($username, $password) {

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Manufacturers = new WG_Manufacturers();
        $Manufacturers->setStatusCode('0');
        $Manufacturers->setStatusMessage('All Ok');

        $Manufacturer = new WG_Manufacturer();
        $Manufacturers->setManufacturers($Manufacturer->getManufacturer());
        // $Manufacturer->setManufacturerID('');
        // $Manufacturer->setManufacturerName('');

        return $this->response($Manufacturers->getManufacturers());
    } //getManufacturers

    #
    # Function to Sync the Items and the Varients with the QB
    #
    public function synchronizeItems($username, $password, $data, $storeid, $others) {

        global $wpdb, $synch_sale_price, $synch_regular_price, $version;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Items = new WG_Items();

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Items->setStatusCode('9997');
            $Items->setStatusMessage('Unknown request or request not in proper format');
            return $this->response($Items->getItems());
        }

        if (count($requestArray) == 0) {
            $Items->setStatusCode('9996');
            $Items->setStatusMessage('REQUEST array(s) doesnt have correct input format');
            return $this->response($Items->getItems());
        }

        $Items->setStatusCode('0');
        $Items->setStatusMessage('All Ok');

        $itemsCount = 0;
        $itemsProcessed = 0;

        // Go throught items
        $itemsCount = 0;
        $_err_message_arr = array();

        $pos = strpos($others, '/');
        if ($pos) {
            $array_others = explode("/", $others);
        } else {
            $array_others = array();
            $array_others[] = $others;
        }

        $countflag = 0;
        $variantNa = 0;
        foreach ($requestArray as $k => $v4) { // request
            $productID = '';
            $Item = new WG_Item();

            $productID = $v4['ProductID'];
            $sku = $v4['Sku'];
            $productName = $v4['ProductName'];
            $qty = $v4['Qty'];
            $price = $v4['Price'];

            if (count(array($v4['ItemVariants'])) > 0) {
                $productdata = array('1');
            } else {
                # Check for record Existence for the Order ID
                $query = "SELECT p.ID FROM $wpdb->posts AS p WHERE p.ID =" . $productID . " AND p.post_type = 'product'";
                $productdata = $wpdb->get_results($query, ARRAY_A);
                $countflag++;
            }

            if (count($productdata) == 0 && $productdata == null) {
                $Item->setStatus('Product #"' . $productID . '" not exist at store!!');
                $Item->setProductID($productID);
                $Items->setItems($Item->getItem());
                continue;
            } else {
                foreach ($array_others as $ot) {
                    $updated_attrib = 0;
                    foreach ($v4['ItemVariants'] as $key => $v5) { // request
                        $vsku = $v5['Sku'];
                        $varient_id = $v5['VarientID'];
                        $varient_qty = $v5['Quantity'];
                        $varient_price = $v5['UnitPrice'];
                        $status = "Success";

                        $query = "SELECT p.ID FROM $wpdb->posts AS p WHERE p.ID =" . $varient_id;
                        $prodvarintdata = $wpdb->get_results($query, ARRAY_A);

                        if (count($prodvarintdata) != 0 && $prodvarintdata != null) {

                            if ($ot == "QTY" || $ot == "BOTH") {
                                if ($varient_qty > 0) {
                                    $var_status = 'instock';
                                    wc_update_product_stock_status($varient_id, $var_status);
                                    wc_update_product_stock_status($productID, $var_status);
                                } else {
                                    $var_status = 'outofstock';
                                    wc_update_product_stock_status($varient_id, $var_status);
                                }

                                wc_update_product_stock($varient_id, $varient_qty);
                                $status = "Success";
                            }

                            if ($ot == "PRICE" || $ot == "BOTH") {
                                if ($synch_sale_price == true) {
                                    if ($synch_regular_price == true) {
                                        update_post_meta($varient_id, '_regular_price', $varient_price);
                                    }

                                    update_post_meta($varient_id, '_sale_price', $varient_price);
                                    update_post_meta($varient_id, '_price', $varient_price);
                                } else {
                                    $sql = "SELECT meta_value FROM $wpdb->postmeta  WHERE post_id = " . $this->mySQLSafe($varient_id) . " AND meta_key = '_sale_price' ";

                                    $product_sale_price = $wpdb->get_results($sql);

                                    if ($product_sale_price[0]->meta_value == '') {
                                        update_post_meta($varient_id, '_price', $varient_price);
                                    }

                                    update_post_meta($varient_id, '_regular_price', $varient_price);
                                }

                                $children = get_posts(array(
                                    'post_parent' => $v4['ProductID'],
                                    'posts_per_page' => -1,
                                    'post_type' => 'product_variation',
                                    'fields' => 'ids',
                                    'post_status' => 'publish',
                                ));

                                $min_variation_price = $min_variation_regular_price = $min_variation_sale_price = $max_variation_price = $max_variation_regular_price = $max_variation_sale_price = 0;

                                $children = &get_children('post_parent=' . $v4['ProductID'] . '&post_type=product_variation');
                                if ($children) {
                                    foreach ($children as $child) {
                                        $sql = "SELECT meta_value FROM $wpdb->postmeta pm   WHERE meta_key = '_price' and pm.post_id = " . $child->ID;
                                        $product_price = $wpdb->get_results($sql);
                                        $child_price = $product_price[0]->meta_value;

                                        if ($min_variation_regular_price == 0) {
                                            $min_variation_regular_price = $child_price;
                                            $max_variation_regular_price = $child_price;
                                        }

                                        // Low price
                                        if ($child_price < $min_variation_regular_price) {
                                            $min_variation_regular_price = $child_price;
                                        }

                                        // High price
                                        if ($child_price > $max_variation_regular_price) {
                                            $max_variation_regular_price = $child_price;
                                        }
                                    }

                                    $min_variation_price = $min_variation_regular_price;
                                    $max_variation_price = $max_variation_regular_price;
                                }

                                update_post_meta($v4['ProductID'], '_price', $min_variation_price);
                                update_post_meta($v4['ProductID'], '_min_variation_price', $min_variation_price);
                                update_post_meta($v4['ProductID'], '_max_variation_price', $max_variation_price);
                                update_post_meta($v4['ProductID'], '_min_variation_regular_price', $min_variation_regular_price);
                                update_post_meta($v4['ProductID'], '_max_variation_regular_price', $max_variation_regular_price);

                                $status = "Success";
                            }

                            $updated_attrib++;

                            $Variant = new WG_Variant();
                            $Variant->setStatus($status);
                            $Variant->setVarientID($varient_id);
                            $Variant->setVariantSku($vsku);
                            $Variant->setQuantity($varient_qty);
                            $Variant->setUnitPrice($varient_price);

                            $Item->setItemVariants($Variant->getVariant());
                        } else {
                            $Variant = new WG_Variant();
                            $Variant->setStatus('Product Variant #"' . $varient_id . '" not exist at store!!');
                            $Variant->setVarientID($varient_id);
                            $Item->setItemVariants($Variant->getVariant());
                            $variantNa = 1;
                            $variantIdNotava = $varient_id;
                        }
                    }

                    if ($updated_attrib == 0) {

                        if ($ot == "QTY" || $ot == "BOTH") {
                            if ($qty > 0) {
                                $status = 'instock';
                            } else {
                                $status = 'outofstock';
                            }

                            wc_update_product_stock($productID, $qty);
                            wc_update_product_stock_status($productID, $status);

                            $status = "Success";
                        }

                        if ($ot == "PRICE" || $ot == "BOTH") {
                            if ($synch_sale_price == true) {
                                if ($synch_regular_price == true) {
                                    update_post_meta($productID, '_regular_price', $price);
                                }

                                update_post_meta($productID, '_sale_price', $price);
                                update_post_meta($productID, '_price', $price);
                            } else {
                                $sql = "SELECT meta_value FROM $wpdb->postmeta  WHERE post_id = " . $this->mySQLSafe($productID) . " AND meta_key = '_sale_price' ";

                                $product_sale_price = $wpdb->get_results($sql);

                                if ($product_sale_price[0]->meta_value == '') {
                                    update_post_meta($productID, '_price', $price);
                                }

                                update_post_meta($productID, '_regular_price', $price);
                            }

                            $status = "Success";
                        }
                        $itemsProcessed++;
                    } else if ($updated_attrib == $k1 + 1) {
                        $itemsProcessed++;
                    }
                }
            }

            if ($version >= '2.2.10') {
                wc_delete_product_transients($productID);
            }

            if ($variantNa == 0) {
                $Item->setStatus('Success');
                $Item->setProductID($v4['ProductID']);
                $Item->setSku($v4['Sku']);
                $Item->setSyncItemqty($qty);
                $Item->setSyncItemprice($price);
                $Items->setItems($Item->getItem());
            } else {
                $Item->setStatus('Product Variant #"' . $variantIdNotava . '" not exist at store!!');
                $Item->setProductID($v4['ProductID']);
                $Items->setItems($Item->getItem());
            }
        }

        return $this->response($Items->getItems());
    } //SynchronizationItems

    #
    # Return the Count of the orders remained with specific dates and status
    #
    public function getOrdersRemained($start_date, $start_order_no = 0, $str_excl_status, $str_date_filter, $LastModifiedDate, $MaxOrderNoInBatch) {

        global $wpdb;
        $hpos_enabled = $this->is_hpos_enabled();

        $previous_orders = 0;

        if ($LastModifiedDate != '') {
            if (!isset($MaxOrderNoInBatch) || $MaxOrderNoInBatch == '') {
                if($hpos_enabled) {
                    $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter . " AND p.type='shop_order' AND p.status!='trash' ORDER BY p.date_updated_gmt, p.ID ASC");
                } else {
                    $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) FROM $wpdb->posts AS p WHERE " . $str_date_filter . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' ORDER BY p.post_modified_gmt, p.ID ASC");
                }
            } else {
                if ($hpos_enabled) {
                    $str_date_filter1 = str_replace('p.date_updated_gmt >', 'p.date_updated_gmt =', $str_date_filter);
                    $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) + (SELECT COUNT(p.ID) FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter . " AND p.type='shop_order' AND p.status!='trash' ORDER BY p.date_updated_gmt, p.ID ASC) FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter1 . " AND p.ID > " . (int) $MaxOrderNoInBatch . " AND p.status!='trash' ORDER BY p.date_updated_gmt, p.ID ASC");
                } else {
                    $str_date_filter1 = str_replace('p.post_modified_gmt >', 'p.post_modified_gmt =', $str_date_filter);
                    $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) + (SELECT COUNT(p.ID) FROM $wpdb->posts AS p WHERE " . $str_date_filter . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND  p.post_status!='trash' ORDER BY p.post_modified_gmt, p.ID ASC) FROM $wpdb->posts AS p WHERE " . $str_date_filter1 . " AND p.ID > " . (int) $MaxOrderNoInBatch . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND  p.post_status!='trash' ORDER BY p.post_modified_gmt, p.ID ASC");
                }
            }
        } else {
            if ($hpos_enabled) {
                $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter . " AND p.type='shop_order' AND p.ID>" . $start_order_no . " AND p.status!='trash' ORDER BY p.ID ASC");
            } else {
                $previous_orders = $wpdb->get_var("SELECT COUNT(p.ID) FROM $wpdb->posts AS p WHERE " . $str_date_filter . " AND p.ID>" . $start_order_no . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' ORDER BY p.ID ASC");
            }
        }

        return $previous_orders;
    }

    #
    # Return the Orders to sync with the QB according to the date and the staus and order id.
    #
    public function getOrders($username, $password, $datefrom, $start_order_no, $ecc_excl_list, $order_per_response = 25, $LastModifiedDate, $storeid, $others, $ccdetails, $MaxOrderNoInBatch, $ProductType, $isRetrievalByLatestCount = 'false') {

        global $wpdb, $version, $woocommerce, $download_order_number;

        $hpos_enabled = $this->is_hpos_enabled();
        $hpos_compatibility_mode_enabled = $this->is_hpos_sync_enabled();

        $version = $woocommerce->version;
        $plugins = get_option('active_plugins');
        $sequential_order_numbers_plugin = 'woocommerce-sequential-order-numbers/woocommerce-sequential-order-numbers.php';
        $sequential_order_numbers_plugin_pro = 'woocommerce-sequential-order-numbers-pro/woocommerce-sequential-order-numbers-pro.php';

        $orderlist = '';
        foreach ($others as $k => $v) {
            $formatted_number_in_pro = false;
            if ($download_order_number == true) {
                if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                    $order_id = wc_seq_order_number_pro()->find_order_by_order_number($v['OrderId']);
                    $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                    $formatted_number_in_pro = true;
                } elseif (in_array($sequential_order_numbers_plugin, $plugins)) {
                    $order_id = wc_sequential_order_numbers()->find_order_by_order_number($v['OrderId']);
                    $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                    $formatted_number_in_pro = false;
                } else {
                    $WgBaseResponse = new WgBaseResponse();
                    $WgBaseResponse->setStatusCode('1');
                    $WgBaseResponse->setStatusMessage('You have checked the option Download orders from order number but you do not install or activate Woocommerce sequential order numbers plugin. So please activate plugin before using this option otherwise uncheck that option (Settings->Webgility).');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } else {
                $orderlist = $orderlist ? ($orderlist . ",'" . $v['OrderId'] . "'") : "'" . $v['OrderId'] . "'";
            }
        }

        if (!isset($LastModifiedDate) || $LastModifiedDate == null || $LastModifiedDate == '') {
            $LastModifiedDate = $datefrom;
        }

        if ($LastModifiedDate) {
            $datefrom2 = explode(" ", $LastModifiedDate);
            $datetime1 = explode("-", $datefrom2[0]);
            $LastModifiedDate = $datetime1[2] . "-" . $datetime1[0] . "-" . $datetime1[1];
            $LastModifiedDate .= " " . $datefrom2[1];
        } elseif (!isset($datefrom) && (!isset($LastModifiedDate))) {
            $datefrom = date('Y-m-d H:i:s');
        } else {
            $datetime1 = explode("-", $datefrom);
            $datefrom = $datetime1[2] . "-" . $datetime1[0] . "-" . $datetime1[1];
            $datefrom .= " 00:00:00";
        }

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        define("QB_ORDERS_PER_RESPONSE", $order_per_response);

        $ecc_excl_list_Ary = explode(',', $ecc_excl_list);
        $ecc_excl_list_id = "";
        if ($version > "2.2.0") {
            $orderStatus = wc_get_order_statuses();
            foreach ($orderStatus as $k => $v) {
                foreach ($ecc_excl_list_Ary as $key => $value) {
                    $label = "'" . strtolower($v) . "'";
                    $ecc_list_val = array(strtolower($value));

                    if (in_array($label, $ecc_list_val)) {
                        $ecc_excl_list_id .= "'" . $k . "',";
                    }
                }
            }
        } else {
            $orderStatus = (array) get_terms('shop_order_status', array('hide_empty' => 0, 'orderby' => 'id'));
            foreach ($orderStatus as $k => $v) {
                if (is_array($v)) {
                    $label = "'" . $orderStatus[$k]['name'] . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]['order'] . ",";
                    }
                } elseif (is_object($v)) {
                    $label = "'" . $orderStatus[$k]->name . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]->term_id . ",";
                    }
                } else {
                    $label = "'" . $orderStatus[$k]->name . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]->order . ",";
                    }
                }
            }
        }
        $ecc_excl_list_id = substr($ecc_excl_list_id, 0, -1);

        define("QB_ORDERS_DOWNLOAD_EXCL_LIST", $ecc_excl_list_id);

        if (!$orderlist && $LastModifiedDate) {
            $last_final = explode(" ", $LastModifiedDate);
            if ($hpos_enabled) {
                $str_date_filter = " p.date_updated_gmt >'" . $last_final[0] . " " . $last_final[1] . "' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_modified_gmt >'" . $last_final[0] . " " . $last_final[1] . "' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        } elseif (!$orderlist && $datefrom) {
            if ($hpos_enabled) {
                $str_date_filter = " p.date_created_gmt >='$datefrom' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_date_gmt >='$datefrom' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        } else {
            if ($hpos_enabled) {
                $str_date_filter = " p.date_updated_gmt >='$datefrom' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_date_gmt >='$datefrom' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        }

        if (!$hpos_enabled) {
            $hposStatus = 'draft';
            $ecc_excl_list_id .= ",";
            $ecc_excl_list_id .= "'" . $hposStatus . "'";
        }
        // echo "<pre>";
        // print_r($ecc_excl_list_id);

        $orders_remained = 0;
        if ($isRetrievalByLatestCount == 'true') {
            $orders_remained = 0;
        } elseif (!$orderlist && $LastModifiedDate) {
            $orders_remained = $this->getOrdersRemained($start_date, $start_order_no, $str_excl_status, $str_date_filter, $LastModifiedDate, $MaxOrderNoInBatch);
            $orders_remained = ($orders_remained > 0) ? $orders_remained : "0";
        } elseif (!$orderlist && $datefrom) {
            $orders_remained = $this->getOrdersRemained($start_date, $start_order_no, $str_excl_status, $str_date_filter, $LastModifiedDate = '', $MaxOrderNoInBatch = 0);
            $orders_remained = ($orders_remained > 0) ? $orders_remained : "0";
        }

        // echo $wpdb->last_query.'<br>';

        if ($isRetrievalByLatestCount == 'true') {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE p.type='shop_order' AND p.status!='trash' ORDER BY p.date_updated_gmt, p.ID DESC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' ORDER BY p.post_modified_gmt, p.ID DESC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            }
        } elseif ($orderlist != '') {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders p WHERE p.ID IN ($orderlist) ORDER BY p.ID ASC", ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts p WHERE p.ID IN ($orderlist) ORDER BY p.ID ASC", ARRAY_A);
            }
        } elseif (!$orderlist && $LastModifiedDate) {
            if (!isset($MaxOrderNoInBatch) || $MaxOrderNoInBatch == '') {
                if ($hpos_enabled) {
                    $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE '" . $LastModifiedDate . "' <= p.date_updated_gmt AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ")  ORDER BY p.date_updated_gmt, p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                } else {
                    $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE '" . $LastModifiedDate . "' <= p.post_modified_gmt AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")  ORDER BY p.post_modified_gmt, p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                }
            } else {
                if ($hpos_enabled) {
                    $orders = $wpdb->get_results("SELECT * FROM (
                        SELECT p.ID, p.date_updated_gmt FROM {$wpdb->prefix}wc_orders AS p WHERE p.date_updated_gmt = '" . $LastModifiedDate . "' AND p.ID >" . (int) $MaxOrderNoInBatch . " AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ")
                        UNION
                        SELECT p.ID, p.date_updated_gmt FROM {$wpdb->prefix}wc_orders AS p WHERE p.date_updated_gmt > '" . $LastModifiedDate . "' AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ")
                    ) as c
                    ORDER BY 2,1
                    " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                } else {
                    $orders = $wpdb->get_results("SELECT * FROM (
                        SELECT p.ID, p.post_modified_gmt FROM $wpdb->posts AS p WHERE p.post_modified_gmt = '" . $LastModifiedDate . "' AND p.ID >" . (int) $MaxOrderNoInBatch . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")
                        UNION
                        SELECT p.ID, p.post_modified_gmt FROM $wpdb->posts AS p WHERE p.post_modified_gmt > '" . $LastModifiedDate . "' AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")
                    ) as c
                    ORDER BY 2,1
                    " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                }
            }
        } else {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter . " AND p.ID>" . $start_order_no . " AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ") ORDER BY p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE " . $str_date_filter . " AND p.ID>" . $start_order_no . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ") ORDER BY p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            }
        }

        // echo $wpdb->last_query.'<br>';

        // $currency = $wpdb->get_results("SELECT option_value FROM $wpdb->options  WHERE option_name = 'woocommerce_currency' ");

        $Orders = new WG_Orders();

        $no_orders = count($orders);
        if ($no_orders <= 0) {
            $no_orders = true;

            $Orders->setStatusCode($no_orders ? "9999" : "0");
            $Orders->setStatusMessage($no_orders ? "No Orders returned" : "Total Orders:" . $orders_remained);
            return $this->response($Orders->getOrders());
        }

        if ($orders) {
            $Orders->setStatusCode(0);
            if ($orders_remained) {
                $Orders->setStatusMessage("Total Orders:" . $orders_remained);
            } else {
                $Orders->setStatusMessage("Total Orders:" . $no_orders);
            }

            foreach ($orders as $info) {
                try {
                    $order = wc_get_order($info['ID']);
                } catch (Exception $e) {
                    $Orders->setStatusCode('9997');
                    $Orders->setStatusMessage("#" . $info['ID'] . "- Order not exists at store.");
                    return $this->response($Orders->getOrders());
                }

                $weightsymbol = 'lbs';
                $weight_symbol_grams = '453.6';

                $Order = new WG_Order();

                if (get_option('webgility_order_number') == 1) {
                    $download_order_number = true;
                } else {
                    $download_order_number = false;
                }

                if ($download_order_number == 1) {
                    if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                        $order_id = wc_seq_order_number_pro()->find_order_by_order_number($order->get_id());
                        $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                        $formatted_number_in_pro = true;
                    } else {
                        $formatted_number_in_pro = false;
                    }
                }

                if (isset($download_order_number) && $download_order_number != '') {
                    $flagvalue = 'true';
                } else {
                    $flagvalue = 'false';
                }

                if ($formatted_number_in_pro) {
                    $order_number = get_post_meta($order->get_id(), '_order_number_formatted', true);
                } else {
                    $order_number = get_post_meta($order->get_id(), '_order_number', true);
                }

                /* Fixed order number downloading and showing issue for Webgility Online */
                if ($ProductType == 'UNIFY') {
                    if (isset($download_order_number) && $download_order_number != '') {
                        $Order->setOrderId($order_number);
                    } else {
                        $Order->setOrderId($order->get_id());
                    }
                } else {
                    $Order->setOrderId($order->get_id());
                }
                /* Fixed order number downloading and showing issue for Webgility Online */

                $Order->setOrderNumber($order_number);
                $Order->OrderNumberFlag($flagvalue);

                $Order->setTitle("");
                $Order->setFirstName($order->get_billing_first_name());
                $Order->setLastName($order->get_billing_last_name());

                $gmt_offset = str_replace('.5', ':30', get_option('gmt_offset'));
                if (strpos($gmt_offset, '-')===false) {
                    $gmt_offset = '+'.$gmt_offset;
                }
                $gmt_offset = ' '.$gmt_offset;

                $Order->setDate(date("m-d-Y", $order->get_date_created()->getOffsetTimestamp()));
                $Order->setTime(date("H:i:s", $order->get_date_created()->getOffsetTimestamp()) . $gmt_offset);

                /* Fix order download and order skip issue. Done */
                $post_modified_gmt_timestamp = $order->get_date_modified()->getTimestamp();
                $Order->setLastModifiedDate(date('m-d-Y H:i:s', $post_modified_gmt_timestamp));

                $Order->setStoreID('');
                $Order->setStoreName('');
                $Order->setCurrency($order->get_currency());
                $Order->setWeight_Symbol($weightsymbol);
                $Order->setWeight_Symbol_Grams($weight_symbol_grams);

                /* Will be use in future when need for custom field */
                // $orderExtraNote = get_post_meta($order->get_id(), 'extra_note', true);

                // $orderNoteField[] = array(
                //  'FieldName' => 'Extra Note',
                //  'FieldValue' => $orderExtraNote,
                // );

                // $Order->setCustomFields($orderNoteField);
                /* Will be use in future when need for custom field */

                $Order->setComment(utf8_encode($order->get_customer_note()) ? utf8_encode($order->get_customer_note()) : "");

                if ($version >= '2.2.10') {
                    $status = wc_get_order_status_name($order->get_status());
                    $Order->setStatus($status);
                } else {
                    $Order->setStatus($order->get_status());
                }

                $orderNote = wc_get_order_notes(array('order_id' => $order->get_id()));
                if (isset($orderNote[0]->content)) {
                    $Order->setNotes(html_entity_decode(strip_tags($orderNote[0]->content)));
                } else {
                    $Order->setNotes('');
                }
                $Order->setFax("");

                #Credit Memo
                $Order->setIsCreditMemoCreated("0");

                $refunds = $order->get_refunds();
                $total_refund = $order->get_total_refunded();

                if ($ProductType == 'UNIFY') {
                    if ($total_refund > 0) {
                        $Order->setIsCreditMemoCreated("1");

                        foreach ($refunds as $refund) {
                            $Refund_ID = $refund->get_id();

                            $refund_fee = 0; //$refund->get_line_subtotal();
                            $refund_total = abs($refund->get_total());
                            $refund_shipping = abs($refund->get_shipping_total());
                            $refund_discount = abs($refund->get_total_discount());
                            $refund_tax = abs($refund->get_total_tax());

                            $CreditMemo = new CreditMemo();
                            $CreditMemo->setCreditMemoID($Refund_ID);

                            // $utc_post_date = get_gmt_from_date( $post_date, 'm-d-Y H:i:s' );
                            $CreditMemo->setCreditMemoDate(date("m-d-Y H:i:s", $refund->get_date_created()->getTimestamp()) ." +0");
                            $CreditMemo->setSubtotal($refund_total);
                            $CreditMemo->setRefundShipping($refund_shipping);
                            $CreditMemo->setRefundDiscount($refund_discount);
                            $CreditMemo->setRefundTax($refund_tax);
                            $CreditMemo->setRefundFee(abs($refund_fee));
                            $CreditMemo->setRefundAdjustment('');

                            foreach ($refund->get_items() as $item_id => $refundId) {
                                $RefundItemID = $refundId['product_id'];

                                $qty = abs($refundId['quantity']);
                                $price = abs($refundId['total']);

                                $orderItemID = wc_get_order_item_meta($item_id, '_refunded_item_id', true);
                                if (isset($refundId['variation_id']) && $refundId['variation_id'] != '0') {
                                    $RefundItemvariationID = $refundId['variation_id'];
                                    $productv = get_metadata('post', $RefundItemvariationID);
                                    $sku = $productv['_sku'][0];
                                    $ItemID = $RefundItemvariationID;
                                } else {
                                    $product = get_metadata('post', $RefundItemID);
                                    $sku = $product['_sku'][0];
                                    $ItemID = $RefundItemID;
                                }

                                $product = get_metadata('post', $RefundItemID);
                                $Productname = $product['_sku'][0];
                                if ($Productname == '') {
                                    continue;
                                }

                                $or_qty = wc_get_order_item_meta($orderItemID, '_qty', true);
                                $or_price = abs(wc_get_order_item_meta($orderItemID, '_line_total', true));

                                $CancelItemDetail = new CancelItemDetail();
                                $CancelItemDetail->setItemID($ItemID);
                                $CancelItemDetail->setItemSku($sku);
                                $CancelItemDetail->setItemName($Productname);
                                $CancelItemDetail->setQtyCancel($qty);
                                $CancelItemDetail->setQtyInOrder($or_qty);

                                // $CancelItemDetail->setPriceCancel($price);
                                if (is_infinite($price) || is_nan($price)) {
                                    $CancelItemDetail->setPriceCancel('0.00');
                                } else {
                                    $CancelItemDetail->setPriceCancel($price);
                                }

                                //$CancelItemDetail->setItemPrice($or_price);
                                if (is_infinite($or_price) || is_nan($or_price)) {
                                    $CancelItemDetail->setItemPrice('0.00');
                                } else {
                                    $CancelItemDetail->setItemPrice($or_price);
                                }

                                $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                            }

                            $Order->setCreditMemos($CreditMemo->getCreditMemo());
                        }
                    }
                } else {
                    if ($total_refund > 0) {
                        $Order->setIsCreditMemoCreated("1");

                        $ccitemArray = array();
                        $totalccitemqty = 0;
                        $creditMemoID = 0; // Reset for every order in loop
                        $shippingRefunded = 0;
                        $shippingTaxRefunded = 0;

                        foreach ($refunds as $refund) {
                            foreach ($refund->get_items() as $item_id => $refundId) {
                                $RefundItemID = $refundId['product_id'];
                                $qty = abs($refundId['quantity']);

                                $item_total_tax = abs($refundId['total_tax']);
                                // $subtotalprice = abs($refundId['subtotal']);
                                $totalitemprice = abs($refundId['total']);

                                $orderItemID = wc_get_order_item_meta($item_id, '_refunded_item_id', true);
                                if (isset($refundId['variation_id']) && $refundId['variation_id'] != '0') {
                                    $RefundItemvariationID = $refundId['variation_id'];
                                    $productv = get_metadata('post', $RefundItemvariationID);
                                    $sku = $productv['_sku'][0];
                                    $ItemID = $RefundItemvariationID;
                                } else {
                                    $product = get_metadata('post', $RefundItemID);
                                    $sku = $product['_sku'][0];
                                    $ItemID = $RefundItemID;
                                }

                                $product = get_metadata('post', $RefundItemID);
                                $Productname = $product['_sku'][0];
                                if ($Productname == '') {
                                    continue;
                                }

                                $or_qty = wc_get_order_item_meta($orderItemID, '_qty', true);
                                $or_price = floatval(wc_get_order_item_meta($orderItemID, '_line_total', true));

                                $totalccitemqty = $totalccitemqty + $qty;
                                if (array_key_exists($sku, $ccitemArray)) {
                                    $ccitemArray[$sku]["qty"] = $ccitemArray[$sku]["qty"] + $qty;
                                    $ccitemArray[$sku]["itemtaxamount"] = $ccitemArray[$sku]["itemtaxamount"] + $item_total_tax;
                                    $ccitemArray[$sku]["refunditemprice"] = $ccitemArray[$sku]["refunditemprice"] + $totalitemprice;
                                } else {
                                    if ($qty != 0) {
                                        $ccitemArray[$sku]["qty"] = $qty;
                                        $ccitemArray[$sku]["name"] = $Productname;
                                        $ccitemArray[$sku]["ID"] = $ItemID;
                                        // $singleitemprice = round($totalitemprice / $qty, 3);
                                        // $ccitemArray[$sku]["refunditemprice"] = $singleitemprice;
                                        $ccitemArray[$sku]["refunditemprice"] = $totalitemprice;
                                        $ccitemArray[$sku]["itemtaxamount"] = $item_total_tax;
                                        $ccitemArray[$sku]["or_qty"] = $or_qty;
                                        $ccitemArray[$sku]["or_price"] = $or_price;
                                    }
                                }
                            }

                            foreach ($refund->get_items('shipping') as $item_id => $refundId) {
                                $shippingRefunded += abs($refundId->get_total());
                                $shippingTaxRefunded += abs($refundId->get_total_tax());
                            }

                            if ($creditMemoID==0) { // Set to latest refund
                                $creditMemoID = $refund->get_id();
                                $creditMemoDate = date("m-d-Y H:i:s", $refund->get_date_created()->getTimestamp()) ." +0";
                            }
                        }

                        $CreditMemo = new CreditMemo();

                        $CreditMemo->setSubtotal($total_refund);
                        $CreditMemo->setCreditMemoID($creditMemoID);
                        $CreditMemo->setCreditMemoDate($creditMemoDate);

                        foreach ($ccitemArray as $cckey => $ccval) {
                            $CancelItemDetail = new CancelItemDetail();

                            $CancelItemDetail->setItemID($ccval["ID"]);
                            $CancelItemDetail->setItemSku($cckey);
                            $CancelItemDetail->setItemName($ccval["name"]);
                            $CancelItemDetail->setQtyCancel($ccval["qty"]);
                            $CancelItemDetail->setQtyInOrder($ccval["or_qty"]);

                            $perQtyPrice = number_format($ccval["refunditemprice"]/$ccval["qty"], 2, '.', '');
                            $CancelItemDetail->setPriceCancel($perQtyPrice);
                            $CancelItemDetail->setItemPrice($perQtyPrice);

                            $itemTaxAMT = $ccval["itemtaxamount"] ? $ccval["itemtaxamount"] : "0.00";
                            $CancelItemDetail->setRefundItemTaxAmount(round($itemTaxAMT, 2));

                            $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                        }

                        # Orders/Ship refund info
                        if ($shippingRefunded || $shippingTaxRefunded) {
                            $CancelItemDetail = new CancelItemDetail();
                            $CancelItemDetail->setItemID('');
                            $CancelItemDetail->setItemSku('SHIPPING_REFUND');
                            $CancelItemDetail->setItemName('SHIPPING_REFUND');
                            $CancelItemDetail->setQtyCancel('1');
                            $CancelItemDetail->setQtyInOrder('1');
                            $CancelItemDetail->setPriceCancel($shippingRefunded);
                            $CancelItemDetail->setItemPrice($shippingRefunded);
                            $CancelItemDetail->setRefundItemTaxAmount($shippingTaxRefunded);
                            $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                        }

                        $Order->setCreditMemos($CreditMemo->getCreditMemo());
                    }
                }

                # Orders/Bill/CreditCard info
                $Bill = new WG_Bill();
                $CreditCard = new WG_CreditCard();
                $txn = "";
                $txnArray = get_post_meta($order->get_id(), '_transaction_id');

                if (is_array($txnArray) && isset($txnArray[0])) {
                    $txn = $txnArray[0];
                }

                $CreditCard->setTransactionId($txn);
                $CreditCard->getCreditCard();
                $Bill->setCreditCardInfo($CreditCard->getCreditCard());

                $Bill->setPayMethod($order->get_payment_method_title() ? $order->get_payment_method_title() : $order->get_payment_method());
                $Bill->setPayStatus('');
                $Bill->setTitle('');

                #Fixed - Customer first and last Name Is Downloading with Special Character's, While Downloading Orders.
                $Bill->setFirstName(preg_replace('/[^(\x20-\x7F)\x0A\x0D]*/', '', $order->get_billing_first_name()));
                $Bill->setLastName(preg_replace('/[^(\x20-\x7F)\x0A\x0D]*/', '', $order->get_billing_last_name()));
                $Bill->setCompanyName($order->get_billing_company());
                #Fixed - Customer first and last Name Is Downloading with Special Character's, While Downloading Orders.

                #Billing details
                $Bill->setAddress1($order->get_billing_address_1());
                $Bill->setAddress2($order->get_billing_address_2());
                $Bill->setCity($order->get_billing_city());
                $Bill->setState($order->get_billing_state());
                $Bill->setZip($order->get_billing_postcode());
                $Bill->setCountry($order->get_billing_country());
                $Bill->setEmail($order->get_billing_email());
                $Bill->setPhone($order->get_billing_phone());
                $Bill->setPONumber('');
                $Order->setOrderBillInfo($Bill->getBill());

                # Orders/Ship info
                $Ship = new WG_Ship();

                $shipping_method = $shipping_carrier = '';
                $shipping_details = $order->get_shipping_methods();
                if (!empty($shipping_details)) {
                    foreach ($shipping_details as $k => $v) {
                        $shipping_method = ucwords(str_replace('_', ' ', $v['method_id']));
                        $shipping_carrier = $v['name'];
                    }
                }
                $Ship->setShipMethod($shipping_method);
                $Ship->setCarrier($shipping_carrier);
                $Ship->setTrackingNumber('');
                $Ship->setTitle('');
                $Ship->setFirstName($order->get_shipping_first_name());
                $Ship->setLastName($order->get_shipping_last_name());
                $Ship->setCompanyName($order->get_shipping_company());
                $Ship->setAddress1($order->get_shipping_address_1());
                $Ship->setAddress2($order->get_shipping_address_2());
                $Ship->setCity($order->get_shipping_city());
                $Ship->setState($order->get_shipping_state());
                $Ship->setZip($order->get_shipping_postcode());
                $Ship->setCountry($order->get_shipping_country());
                $Ship->setEmail('');
                $Ship->setPhone($order->get_shipping_phone() ? $order->get_shipping_phone() : $order->get_billing_phone());

                $Order->setOrderShipInfo($Ship->getShip());

                // unset($shipping_carrier, $shipping_method);
                if (isset($order->order_custom_fields['_order_items'][0])) {
                    $product_items = $order->order_custom_fields['_order_items'][0];
                    $product_items_arr = unserialize($product_items);
                } else {
                    $product_items_arr = "";
                }

                $total_tax = 0;
                if ($version >= '2.0.0') {
                    foreach ($order->get_items() as $cart_row) {
                        $itemNoteField = array();
                        $Item = new WG_Item();

                        if ($cart_row['variation_id'] > 0) {
                            $_product = get_metadata('post', $cart_row['variation_id']);
                            if (empty($_product['_sku'][0])) {
                                $varsku = get_post_meta($cart_row['product_id'], '_sku');
                                $_product['_sku'][0] = $varsku[0];
                            }
                            if (empty($_product['_length'][0])) {
                                $_length = get_post_meta($cart_row['product_id'], '_length');
                                $_product['_length'][0] = $_length[0];
                            }
                            if (empty($_product['_width'][0])) {
                                $_width = get_post_meta($cart_row['product_id'], '_width');
                                $_product['_width'][0] = $_width[0];
                            }
                            if (empty($_product['_height'][0])) {
                                $_height = get_post_meta($cart_row['product_id'], '_height');
                                $_product['_height'][0] = $_height[0];
                            }
                            if (empty($_product['_weight'][0])) {
                                $_weight = get_post_meta($cart_row['product_id'], '_weight');
                                $_product['_weight'][0] = $_weight[0];
                            }
                        } else {
                            $_product = get_metadata('post', $cart_row['product_id']);
                        }

                        $item_meta = new WC_Order_Item_Product($cart_row['item_meta']);

                        /* Will be use in future when need for custom field */
                        // $item_note = get_post_meta($cart_row['product_id'], 'item_note', true);
                        // $item_vendorText = get_post_meta($cart_row['product_id'], 'item_vendor', true);

                        // $itemNoteField[] = array(
                        //    'FieldName' => 'Item Note',
                        //    'FieldValue' => $item_note,
                        // );

                        // $itemNoteField[] = array(
                        //    'FieldName' => 'Item Vendor',
                        //    'FieldValue' => $item_vendorText,
                        // );

                        // $Item->setCustomFields($itemNoteField);
                        /* Will be use in future when need for custom field */

                        $Item->setItemID($cart_row['product_id']);
                        $Item->setItemCode($_product['_sku'][0] ? $_product['_sku'][0] : $cart_row['name']);

                        $product_fields = $wpdb->get_results("SELECT p.post_title, p.post_content FROM $wpdb->posts p WHERE p.ID = " . $cart_row['product_id'] . "  ", ARRAY_A);

                        $Item->setItemDescription(html_entity_decode(stripslashes($product_fields[0]['post_title']) ? ($product_fields[0]['post_title']) : $cart_row['name']));

                        $desc = "";
                        if ($cart_row['variation_id'] > 0) {
                            $desc = htmlentities(substr(html_entity_decode($_product['_variation_description'][0]), 0, 4000), ENT_QUOTES);
                        } else {
                            $desc = htmlentities(substr(html_entity_decode($product_fields[0]['post_content']), 0, 4000), ENT_QUOTES);
                        }

                        $Item->setItemShortDescr(strip_tags(htmlentities($desc)));
                        unset($desc);

                        // $weight_unit = get_option('woocommerce_weight_unit');
                        // $dimension_unit = get_option('woocommerce_dimension_unit');
                        $Item->setQuantity($cart_row['qty']);

                        $Dimention['Length'] = (float) $_product['_length'][0];
                        $Dimention['Width'] = (float) $_product['_width'][0];
                        $Dimention['Height'] = (float) $_product['_height'][0];
                        // $Dimention['Unit'] = $dimension_unit;
                        $Dimention['Unit'] = 'in';
                        $Item->setDimention($Dimention);

                        if ($cart_row['qty'] > 0) {
                            $unitPrice = $cart_row['line_subtotal'] / $cart_row['qty'];
                        } else {
                            $unitPrice = $cart_row['line_subtotal'];
                        }

                        #$Item->setUnitPrice($unitPrice);
                        if (is_infinite($unitPrice) || is_nan($unitPrice)) {
                            $Item->setUnitPrice('0.00');
                        } else {
                            $Item->setUnitPrice($unitPrice);
                        }

                        // $to_unit = $weight_unit;
                        $to_unit = 'lbs';
                        $weight_in_lbs = wc_get_weight($_product['_weight'][0], $to_unit);
                        $Item->setWeight(round($weight_in_lbs, 4));
                        $Item->setFreeShipping('');
                        $Item->setDiscounted('');
                        $Item->setshippingFreight('');
                        $Item->setWeight_Symbol($weightsymbol);
                        $Item->setWeight_Symbol_Grams($weight_symbol_grams);

                        // Bug Fixed - #225658 - sales tax problem (SM-Item set as Non Taxable but when they are downloading in the orders, they are coming with Taxable code.)
                        if ($cart_row['line_subtotal_tax'] == 0 && $cart_row['line_tax'] == 0) {
                            $Item->setTaxExempt('Y');
                        } elseif ($cart_row['line_subtotal_tax'] != "" && $cart_row['line_tax'] != "") {
                            $Item->setTaxExempt('N');
                        } else {
                            $Item->setTaxExempt('Y');
                        }

                        $Item->setOneTimeCharge('');
                        $Item->setItemTaxAmount($cart_row['line_subtotal_tax']);

                        $Itemoption = new WG_Itemoption();

                        /* Fixed - Size and colour getting download  with the order with extra characters in Webgility */
                        foreach ($_product as $meta_k => $meta_v) {
                            $pos = strpos($meta_k, 'attribute_pa_');

                            if ($pos !== false) {
                                $name = explode("_", $meta_k);
                                $term = get_term_by('slug', $meta_value, esc_attr(str_replace('attribute_pa_', '', $meta_key)));
                                if (!is_wp_error($term) && $term->name) {
                                    $meta_value = $term->name;
                                }

                                #if attrubute has blank value
                                if (empty($meta_v[0]) && isset($item_meta->meta[$name[1]][0])) {
                                    $meta_v[0] = $item_meta->meta[$name[1]][0];
                                }

                                /* #Fixed - Attribute Color not downloading for some items in orders in Webgility */
                                $metaValueHasdash = strpos($meta_v[0], '-');
                                if ($metaValueHasdash === false) {
                                    $Itemoption->setOptionName($name[2]);
                                    $Itemoption->setOptionValue($meta_v[0]);
                                } else {
                                    $words = explode('-', $meta_v[0]);
                                    $Itemoption->setOptionName($name[2]);
                                    $Itemoption->setOptionValue($words[1]);
                                }
                                /* #Fixed - Attribute Color not downloading for some items in orders in Webgility */

                                $Item->setItemOptions($Itemoption->getItemoption());
                            }
                        }
                        /* Fixed - Size and colour getting download with the order with extra characters in Webgility */

                        foreach ($item_meta->meta as $meta_key => $meta_value) {
                            if (!$meta_value || (substr($meta_key, 0, 1) == '_')) {
                                continue;
                            }

                            $meta_key = wp_kses_post($meta_key);
                            // $meta_key = preg_replace('/&#036;/', '', $meta_key);
                            // $meta_key = str_replace('$', '', $meta_key);
                            $meta_key = str_replace('pa_', '', $meta_key);
                            $Itemoption->setOptionName($meta_key);
                            if (is_array($meta_value)) {
                                foreach ($meta_value as $key => $value) {
                                    $Itemoption->setOptionValue(wp_kses_post($value));
                                }
                            } else {
                                $Itemoption->setOptionValue(wp_kses_post($meta_value));
                            }

                            // $Itemoption->setOther1(wp_kses_post( $meta_value ));
                            $Item->setItemOptions($Itemoption->getItemoption());
                        }

                        // CODE UPDATED BECAUSE OF TAX ISSUE WHILE USING DISCOUNT @ 2-SEP-2013
                        // $total_tax = $total_tax + $cart_row['line_subtotal_tax'] + $order->get_shipping_tax();
                        $total_tax = $total_tax + $cart_row['line_tax'];
                        // END OF TAX CODE UPDATE

                        $Order->setOrderItems($Item->getItem());
                    } // end items
                } else {
                    foreach ($product_items_arr as $cart_row) {
                        $Item = new WG_Item();

                        if ($cart_row['variation_id'] > 0) {
                            // $item_price = $_product->sale_price;
                            $_product = new WC_Product_Variation($cart_row['variation_id']);
                        } else {
                            // $item_price = $_product->sale_price;
                            $_product = new WC_Product($cart_row['id']);
                        }

                        $Item->setItemCode($_product->sku ? $_product->sku : $cart_row['name']);
                        // echo "SELECT p.post_title FROM $wpdb->posts p WHERE p.ID = ".$cart_row['id']."  ";
                        $product_fields = $wpdb->get_results("SELECT p.post_title, p.post_content FROM $wpdb->posts p WHERE p.ID = " . $cart_row['id'] . "  ", ARRAY_A);

                        $Item->setItemDescription(html_entity_decode(stripslashes($product_fields[0]['post_title']) ? ($product_fields[0]['post_title']) : $cart_row['name']));

                        $Item->setQuantity($cart_row['qty']);

                        $sql = "SELECT meta_value FROM " . WPSC_TABLE_PRODUCTMETA . " AS meta WHERE meta.product_id = " . $cart_row['prodid'] . " and meta_key='sku'";
                        $product_meta_sku = $wpdb->get_results($sql, ARRAY_A);

                        $Dimention['Length'] = (float) $_product->length;
                        $Dimention['Width'] = (float) $_product->width;
                        $Dimention['Height'] = (float) $_product->height;
                        $Dimention['Unit'] = 'cm';
                        $Item->setDimention($Dimention);

                        if ($cart_row['qty'] > 0) {
                            $unitPrice = $cart_row['line_subtotal'] / $cart_row['qty'];
                        } else {
                            $unitPrice = $cart_row['line_subtotal'];
                        }

                        $Item->setUnitPrice($unitPrice);
                        $to_unit = 'lbs';
                        $weight_in_lbs = wc_get_weight($_product->weight, $to_unit);
                        $Item->setWeight($weight_in_lbs);
                        $Item->setFreeShipping('');
                        $Item->setDiscounted('');
                        $Item->setshippingFreight('');
                        $Item->setWeight_Symbol($weightsymbol);
                        $Item->setWeight_Symbol_Grams($weight_symbol_grams);

                        // Bug Fixed - #225658 - sales tax problem (SM-Item set as Non Taxable but when they are downloading in the orders, they are coming with Taxable code.)
                        if ($cart_row['line_subtotal_tax'] == 0 && $cart_row['line_tax'] == 0) {
                            $Item->setTaxExempt('Y');
                        } elseif ($cart_row['line_subtotal_tax'] != "" && $cart_row['line_tax'] != "") {
                            $Item->setTaxExempt('N');
                        } else {
                            $Item->setTaxExempt('Y');
                        }

                        $Item->setOneTimeCharge('');
                        $Item->setItemTaxAmount($cart_row['line_subtotal_tax']);

                        $Itemoption = new WG_Itemoption();

                        foreach ($cart_row['item_meta'] as $option) {
                            $Itemoption->setOptionName(htmlentities(ucfirst(sanitize_title(str_replace('pa_', '', $option['meta_name'])))));
                            $Itemoption->setOptionValue(htmlentities($option['meta_value']));

                            $Item->setItemOptions($Itemoption->getItemoption());
                        }

                        $total_tax = $total_tax + $cart_row['line_subtotal_tax'];

                        $Order->setOrderItems($Item->getItem());
                    } // end items
                    // Download fee as a line item
                }

                foreach ($order->get_fees() as $key => $order_fee) {
                    if (isset($order_fee['total']) || isset($order_fee['line_total'])) {
                        $Item = new WG_Item();

                        if (!empty($order_fee['total'])) {
                            $total = $order_fee['total'];
                        } elseif (!empty($order_fee['line_total'])) {
                            $total = $order_fee['line_total'];
                        } else {
                            $total = "0.00";
                        }

                        if (isset($order_fee['total_tax']) && $order_fee['total_tax'] != '') {
                            $total_tax = $total_tax + $order_fee['total_tax'];
                        }

                        $Item->setItemCode($order_fee['name']);
                        $Item->setItemDescription($order_fee['name']);
                        $Item->setItemShortDescr($order_fee['name']);
                        $Item->setQuantity(intval(1));
                        $Item->setUnitPrice($total);
                        $Order->setOrderItems($Item->getItem());
                    }
                }

                $charges = new WG_Charges();

                // $order_tot_discount = $order->order_discount ? $order->order_discount : 0.00;
                $order_tot_discount = 0.00;
                if (($order->get_total_discount() !== null) && $order->get_total_discount() > '0.00') {
                    $order_tot_discount = $order_tot_discount + $order->get_total_discount() ? $order->get_total_discount() : 0.00;
                }
                $charges->setDiscount($order_tot_discount);

                $charges->setStoreCredit('0.00');

                #Fixed if order has tax either in string or in array format
                $order_shipping_tax = $order->get_shipping_tax();

                if (is_array($order_shipping_tax)) {
                    $order_total_tax = $order_shipping_tax['total'];
                } else {
                    $order_total_tax = $order->get_shipping_tax();
                }

                $totalTaxWithShipping = floatval($total_tax) + floatval($order_total_tax);

                $charges->setTax($totalTaxWithShipping ? $totalTaxWithShipping : '0.00');

                unset($total_tax);
                // $charges->setTax($total_tax + $order->get_shipping_tax() ? $total_tax + $order->get_shipping_tax() : '0.00');
                #Fixed if order has tax either in string or in array format
                $charges->setShipping($order->get_shipping_total() ? $order->get_shipping_total() : '0.00');
                $charges->setSubTotal($order->get_subtotal() ? $order->get_subtotal() : "0.00");
                $charges->setTotal($order->get_total() ? $order->get_total() : "0.00");

                $Order->setOrderChargeInfo($charges->getCharges());

                $Order->setShippedOn(date("m-d-Y H:i:s", $order->get_date_modified()->getTimestamp()));
                $shipping_method_title = $order->get_shipping_method();
                $Order->setShippedVia($shipping_method_title ? $shipping_method_title : $shipping_method);

                $MaxOrderNoInBatch = $order->get_id();

                $MaxdateNoInBatch = date("Y-m-d H:i:s", $order->get_date_modified()->getTimestamp());
                $Orders->setOrders($Order->getOrder());
            }
        }

        if ($hpos_enabled) {
            $sql = "SELECT COUNT(*) AS total FROM {$wpdb->prefix}wc_orders AS p where p.ID >" . (int) $MaxOrderNoInBatch . "  AND p.date_updated_gmt LIKE '%" . $MaxdateNoInBatch . "%' ORDER BY p.date_updated_gmt, p.ID ASC";
        } else {
            $sql = "SELECT COUNT(*) AS total FROM $wpdb->posts AS p where p.ID >" . (int) $MaxOrderNoInBatch . "  AND p.post_modified_gmt LIKE '%" . $MaxdateNoInBatch . "%' ORDER BY p.post_modified_gmt, p.ID ASC";
        }
        // echo $sql;
        $query = $wpdb->get_results($sql, ARRAY_A);

        if ($query[0]['total'] > 0) {
            $Orders->setMaxOrderNoInBatch($MaxOrderNoInBatch);
        } else {
            $Orders->setMaxOrderNoInBatch("");
        }

        if (isset($download_order_number) && $download_order_number != '') {
            $flagvalue = 'true';
        } else {
            $flagvalue = 'false';
        }

        $Orders->OrderNumberFlag($flagvalue);

        return $this->response($Orders->getOrders());
    } // getOrders

    /* Orders download By Date Range */
    public function getOrdersByDateRange($username, $password, $startdaterange, $enddaterange, $ecc_excl_list, $order_per_response = 25, $LastModifiedDate, $storeid, $others, $ccdetails, $MaxOrderNoInBatch, $ProductType, $isRetrievalByLatestCount = 'false') {

        global $wpdb, $version, $woocommerce, $download_order_number;

        $hpos_enabled = $this->is_hpos_enabled();
        $hpos_compatibility_mode_enabled = $this->is_hpos_sync_enabled();

        $version = $woocommerce->version;
        $plugins = get_option('active_plugins');
        $sequential_order_numbers_plugin = 'woocommerce-sequential-order-numbers/woocommerce-sequential-order-numbers.php';
        $sequential_order_numbers_plugin_pro = 'woocommerce-sequential-order-numbers-pro/woocommerce-sequential-order-numbers-pro.php';

        $orderlist = '';
        foreach ($others as $k => $v) {
            $formatted_number_in_pro = false;
            if ($download_order_number == true) {
                if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                    $order_id = wc_seq_order_number_pro()->find_order_by_order_number($v['OrderId']);
                    $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                    $formatted_number_in_pro = true;
                } elseif (in_array($sequential_order_numbers_plugin, $plugins)) {
                    $order_id = wc_sequential_order_numbers()->find_order_by_order_number($v['OrderId']);
                    $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                    $formatted_number_in_pro = false;
                } else {
                    $WgBaseResponse = new WgBaseResponse();
                    $WgBaseResponse->setStatusCode('1');
                    $WgBaseResponse->setStatusMessage('You have checked the option Download orders from order number but you do not install or activate Woocommerce sequential order numbers plugin. So please activate plugin before using this option otherwise uncheck that option (Settings->Webgility).');
                    return $this->response($WgBaseResponse->getBaseResponse());
                    exit;
                }
            } else {
                $orderlist = $orderlist ? ($orderlist . ",'" . $v['OrderId'] . "'") : "'" . $v['OrderId'] . "'";
            }
        }

        $StartDateRange = $startdaterange;
        $EndDateRange = $enddaterange;

        if (!isset($LastModifiedDate) || $LastModifiedDate == null || $LastModifiedDate == '') {
            $LastModifiedDate = $datefrom;
        }

        if ($LastModifiedDate) {
            $datefrom2 = explode(" ", $LastModifiedDate);
            $datetime1 = explode("-", $datefrom2[0]);
            $LastModifiedDate = $datetime1[2] . "-" . $datetime1[0] . "-" . $datetime1[1];
            $LastModifiedDate .= " " . $datefrom2[1];
        } elseif (!isset($datefrom) && (!isset($LastModifiedDate))) {
            $datefrom = date('Y-m-d H:i:s');
        } else {
            $datetime1 = explode("-", $datefrom);
            $datefrom = $datetime1[2] . "-" . $datetime1[0] . "-" . $datetime1[1];
            $datefrom .= " 00:00:00";
        }

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        define("QB_ORDERS_PER_RESPONSE", $order_per_response);

        $ecc_excl_list_Ary = explode(',', $ecc_excl_list);
        $ecc_excl_list_id = "";
        if ($version > "2.2.0") {
            $orderStatus = wc_get_order_statuses();
            foreach ($orderStatus as $k => $v) {
                foreach ($ecc_excl_list_Ary as $key => $value) {
                    $label = "'" . strtolower($v) . "'";
                    $ecc_list_val = array(strtolower($value));

                    if (in_array($label, $ecc_list_val)) {
                        $ecc_excl_list_id .= "'" . $k . "',";
                    }
                }
            }
        } else {
            $orderStatus = (array) get_terms('shop_order_status', array('hide_empty' => 0, 'orderby' => 'id'));
            foreach ($orderStatus as $k => $v) {
                if (is_array($v)) {
                    $label = "'" . $orderStatus[$k]['name'] . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]['order'] . ",";
                    }
                } elseif (is_object($v)) {
                    $label = "'" . $orderStatus[$k]->name . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]->term_id . ",";
                    }
                } else {
                    $label = "'" . $orderStatus[$k]->name . "'";

                    if (in_array($label, $ecc_excl_list_Ary)) {
                        $ecc_excl_list_id .= $orderStatus[$k]->order . ",";
                    }
                }
            }
        }
        $ecc_excl_list_id = substr($ecc_excl_list_id, 0, -1);

        define("QB_ORDERS_DOWNLOAD_EXCL_LIST", $ecc_excl_list_id);

        if (!$orderlist && $LastModifiedDate) {
            $last_final = explode(" ", $LastModifiedDate);
            if ($hpos_enabled) {
                $str_date_filter = " p.date_updated_gmt >'" . $last_final[0] . "' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_modified_gmt >'" . $last_final[0] . "' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        } elseif (!$orderlist && $datefrom) {
            if ($hpos_enabled) {
                $str_date_filter = " p.date_created_gmt >='$datefrom' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_date_gmt >='$datefrom' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        } else {
            if ($hpos_enabled) {
                $str_date_filter = " p.date_updated_gmt >='$datefrom' AND p.status IN (" . $ecc_excl_list_id . ") ";
            } else {
                $str_date_filter = " p.post_date_gmt >='$datefrom' AND p.post_status IN (" . $ecc_excl_list_id . ") ";
            }
        }

        if (!$hpos_enabled) {
            $hposStatus = 'draft';
            $ecc_excl_list_id .= ",";
            $ecc_excl_list_id .= "'" . $hposStatus . "'";
        }
        // echo "<pre>";
        // print_r($ecc_excl_list_id);

        $orders_remained = 0;
        if ($isRetrievalByLatestCount == 'true') {
            $orders_remained = 0;
        } elseif (!$orderlist && $LastModifiedDate) {
            $orders_remained = $this->getOrdersRemained($start_date, $start_order_no, $str_excl_status, $str_date_filter, $LastModifiedDate, $MaxOrderNoInBatch);
            $orders_remained = ($orders_remained > 0) ? $orders_remained : "0";
        } elseif (!$orderlist && $datefrom) {
            $orders_remained = $this->getOrdersRemained($start_date, $start_order_no, $str_excl_status, $str_date_filter, $LastModifiedDate = '', $MaxOrderNoInBatch = 0);
            $orders_remained = ($orders_remained > 0) ? $orders_remained : "0";
        }

        if ($isRetrievalByLatestCount == 'true') {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE p.type='shop_order' AND p.status!='trash' ORDER BY p.date_updated_gmt, p.ID DESC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' ORDER BY p.post_modified_gmt, p.ID DESC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            }
        } elseif ($orderlist != '') {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders p WHERE p.ID IN ($orderlist) ORDER BY p.ID ASC", ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts p WHERE p.ID IN ($orderlist) ORDER BY p.ID ASC", ARRAY_A);
            }
        } elseif (!$orderlist && $LastModifiedDate) {
            if (!isset($MaxOrderNoInBatch) || $MaxOrderNoInBatch == '') {
                #Fixed :- download the orders as per the Order range issue. jira id:-  SM-990
                if ($hpos_enabled) {
                    $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE (DATE_FORMAT(p.date_updated_gmt, '%Y-%m-%d %H:%i:%s') BETWEEN  '" . $StartDateRange . "' AND '" . $EndDateRange . "') AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ")  ORDER BY p.date_updated_gmt, p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                } else {
                    $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE ( DATE_FORMAT( p.post_modified_gmt, '%Y-%m-%d %H:%i:%s' ) BETWEEN  '" . $StartDateRange . "' AND '" . $EndDateRange . "' ) AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")  ORDER BY p.post_modified_gmt, p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                }
            } else {
                /* SM-1049 - FIxed - Issue order was downloading in loop. Same order was downloading everytime. */
                if ($hpos_enabled) {
                    $values_LastModifiedDate = $wpdb->get_var("SELECT date_updated_gmt FROM {$wpdb->prefix}wc_orders WHERE ID = " . (int) $MaxOrderNoInBatch);
                    $orders = $wpdb->get_results("SELECT * FROM (
                        SELECT p.ID, p.date_updated_gmt FROM {$wpdb->prefix}wc_orders AS p WHERE p.date_updated_gmt  = '" . $values_LastModifiedDate . "' AND p.ID >" . (int) $MaxOrderNoInBatch . " AND p.type='shop_order' AND p.status!='trash' AND p.post IN (" . $ecc_excl_list_id . ")
                        UNION
                        SELECT p.ID, p.date_updated_gmt FROM {$wpdb->prefix}wc_orders AS p WHERE p.date_updated_gmt  > '" . $values_LastModifiedDate . "' AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ")
                    ) as c
                    ORDER BY 2,1
                    " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                } else {
                    $values_LastModifiedDate = $wpdb->get_var("SELECT post_modified_gmt FROM $wpdb->posts WHERE ID = " . (int) $MaxOrderNoInBatch);
                    $orders = $wpdb->get_results("SELECT * FROM (
                        SELECT p.ID, p.post_modified_gmt FROM $wpdb->posts AS p WHERE p.post_modified_gmt  = '" . $values_LastModifiedDate . "' AND p.ID >" . (int) $MaxOrderNoInBatch . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")
                        UNION
                        SELECT p.ID, p.post_modified_gmt FROM $wpdb->posts AS p WHERE p.post_modified_gmt  > '" . $values_LastModifiedDate . "' AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ")
                    ) as c
                    ORDER BY 2,1
                    " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
                }
                /* SM-1049 - FIxed - Issue order was downloading in loop. Same order was downloading everytime. */
            }
        } else {
            if ($hpos_enabled) {
                $orders = $wpdb->get_results("SELECT p.ID FROM {$wpdb->prefix}wc_orders AS p WHERE " . $str_date_filter . " AND p.ID>" . $start_order_no . " AND p.type='shop_order' AND p.status!='trash' AND p.status IN (" . $ecc_excl_list_id . ") ORDER BY p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            } else {
                $orders = $wpdb->get_results("SELECT p.ID FROM $wpdb->posts AS p WHERE " . $str_date_filter . " AND p.ID>" . $start_order_no . " AND (p.post_type='shop_order' || p.post_type='shop_order_placehold') AND p.post_status!='trash' AND p.post_status IN (" . $ecc_excl_list_id . ") ORDER BY p.ID ASC " . (QB_ORDERS_PER_RESPONSE > 0 ? "LIMIT 0, " . QB_ORDERS_PER_RESPONSE : ''), ARRAY_A);
            }
        }

        // $currency = $wpdb->get_results("SELECT option_value FROM $wpdb->options  WHERE option_name = 'woocommerce_currency' ");

        $Orders = new WG_Orders();

        $no_orders = count($orders);
        if ($no_orders <= 0) {
            $no_orders = true;

            $Orders->setStatusCode($no_orders ? "9999" : "0");
            $Orders->setStatusMessage($no_orders ? "No Orders returned" : "Total Orders:" . $orders_remained);
            return $this->response($Orders->getOrders());
        }

        if ($orders) {
            $Orders->setStatusCode(0);
            if ($orders_remained) {
                $Orders->setStatusMessage("Total Orders:" . $orders_remained);
            } else {
                $Orders->setStatusMessage("Total Orders:" . $no_orders);
            }

            foreach ($orders as $info) {
                try {
                    $order = wc_get_order($info['ID']);
                } catch (Exception $e) {
                    $Orders->setStatusCode('9997');
                    $Orders->setStatusMessage("#" . $info['ID'] . "- Order not exists at store.");
                    return $this->response($Orders->getOrders());
                }

                $weightsymbol = 'lbs';
                $weight_symbol_grams = '453.6';

                $Order = new WG_Order();

                if (get_option('webgility_order_number') == 1) {
                    $download_order_number = true;
                } else {
                    $download_order_number = false;
                }

                if ($download_order_number == 1) {
                    if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                        $order_id = wc_seq_order_number_pro()->find_order_by_order_number($order->get_id());
                        $orderlist = $orderlist ? ($orderlist . ",'" . $order_id . "'") : "'" . $order_id . "'";
                        $formatted_number_in_pro = true;
                    } else {
                        $formatted_number_in_pro = false;
                    }
                }

                if (isset($download_order_number) && $download_order_number != '') {
                    $flagvalue = 'true';
                } else {
                    $flagvalue = 'false';
                }

                if ($formatted_number_in_pro) {
                    $order_number = get_post_meta($order->get_id(), '_order_number_formatted', true);
                } else {
                    $order_number = get_post_meta($order->get_id(), '_order_number', true);
                }

                /* Fixed order number downloading and showing issue for Webgility Online */
                if ($ProductType == 'UNIFY') {
                    if (isset($download_order_number) && $download_order_number != '') {
                        $Order->setOrderId($order_number);
                    } else {
                        $Order->setOrderId($order->get_id());
                    }
                } else {
                    $Order->setOrderId($order->get_id());
                }
                /* Fixed order number downloading and showing issue for Webgility Online */

                $Order->setOrderNumber($order_number);
                $Order->OrderNumberFlag($flagvalue);

                $Order->setTitle("");
                $Order->setFirstName($order->get_billing_first_name());
                $Order->setLastName($order->get_billing_last_name());

                $gmt_offset = str_replace('.5', ':30', get_option('gmt_offset'));
                if (strpos($gmt_offset, '-')===false) {
                    $gmt_offset = '+'.$gmt_offset;
                }
                $gmt_offset = ' '.$gmt_offset;

                $Order->setDate(date("m-d-Y", $order->get_date_created()->getOffsetTimestamp()));
                $Order->setTime(date("H:i:s", $order->get_date_created()->getOffsetTimestamp()) . $gmt_offset);

                /* Fix order download and order skip issue. Done */
                $post_modified_gmt_timestamp = $order->get_date_modified()->getTimestamp();
                $Order->setLastModifiedDate(date('m-d-Y H:i:s', $post_modified_gmt_timestamp));

                $Order->setStoreID('');
                $Order->setStoreName('');
                $Order->setCurrency($order->get_currency());
                $Order->setWeight_Symbol($weightsymbol);
                $Order->setWeight_Symbol_Grams($weight_symbol_grams);

                /* Will be use in future when need for custom field */
                // $orderExtraNote = get_post_meta($order->get_id(), 'extra_note', true);

                // $orderNoteField[] = array(
                //  'FieldName' => 'Extra Note',
                //  'FieldValue' => $orderExtraNote,
                // );

                // $Order->setCustomFields($orderNoteField);
                /* Will be use in future when need for custom field */

                $Order->setComment(utf8_encode($order->get_customer_note()) ? utf8_encode($order->get_customer_note()) : "");

                if ($version >= '2.2.10') {
                    $status = wc_get_order_status_name($order->get_status());
                    $Order->setStatus($status);
                } else {
                    $Order->setStatus($order->get_status());
                }

                $orderNote = wc_get_order_notes(array('order_id' => $order->get_id()));
                if (isset($orderNote[0]->content)) {
                    $Order->setNotes(html_entity_decode(strip_tags($orderNote[0]->content)));
                } else {
                    $Order->setNotes('');
                }
                $Order->setFax("");

                #Credit Memo
                $Order->setIsCreditMemoCreated("0");

                $refunds = $order->get_refunds();
                $total_refund = $order->get_total_refunded();

                if ($ProductType == 'UNIFY') {
                    if ($total_refund > 0) {
                        $Order->setIsCreditMemoCreated("1");

                        foreach ($refunds as $refund) {
                            $Refund_ID = $refund->get_id();

                            $refund_fee = 0; //$refund->get_line_subtotal();
                            $refund_total = abs($refund->get_total());
                            $refund_shipping = abs($refund->get_shipping_total());
                            $refund_discount = abs($refund->get_total_discount());
                            $refund_tax = abs($refund->get_total_tax());

                            $CreditMemo = new CreditMemo();
                            $CreditMemo->setCreditMemoID($Refund_ID);

                            // $utc_post_date = get_gmt_from_date( $post_date, 'm-d-Y H:i:s' );
                            $CreditMemo->setCreditMemoDate(date("m-d-Y H:i:s", $refund->get_date_created()->getTimestamp()) ." +0");
                            $CreditMemo->setSubtotal($refund_total);
                            $CreditMemo->setRefundShipping($refund_shipping);
                            $CreditMemo->setRefundDiscount($refund_discount);
                            $CreditMemo->setRefundTax($refund_tax);
                            $CreditMemo->setRefundFee(abs($refund_fee));
                            $CreditMemo->setRefundAdjustment('');

                            foreach ($refund->get_items() as $item_id => $refundId) {
                                $RefundItemID = $refundId['product_id'];

                                $qty = abs($refundId['quantity']);
                                $price = abs($refundId['total']);

                                $orderItemID = wc_get_order_item_meta($item_id, '_refunded_item_id', true);
                                if (isset($refundId['variation_id']) && $refundId['variation_id'] != '0') {
                                    $RefundItemvariationID = $refundId['variation_id'];
                                    $productv = get_metadata('post', $RefundItemvariationID);
                                    $sku = $productv['_sku'][0];
                                    $ItemID = $RefundItemvariationID;
                                } else {
                                    $product = get_metadata('post', $RefundItemID);
                                    $sku = $product['_sku'][0];
                                    $ItemID = $RefundItemID;
                                }

                                $product = get_metadata('post', $RefundItemID);
                                $Productname = $product['_sku'][0];
                                if ($Productname == '') {
                                    continue;
                                }

                                $or_qty = wc_get_order_item_meta($orderItemID, '_qty', true);
                                $or_price = abs(wc_get_order_item_meta($orderItemID, '_line_total', true));

                                $CancelItemDetail = new CancelItemDetail();
                                $CancelItemDetail->setItemID($ItemID);
                                $CancelItemDetail->setItemSku($sku);
                                $CancelItemDetail->setItemName($Productname);
                                $CancelItemDetail->setQtyCancel($qty);
                                $CancelItemDetail->setQtyInOrder($or_qty);

                                // $CancelItemDetail->setPriceCancel($price);
                                if (is_infinite($price) || is_nan($price)) {
                                    $CancelItemDetail->setPriceCancel('0.00');
                                } else {
                                    $CancelItemDetail->setPriceCancel($price);
                                }

                                //$CancelItemDetail->setItemPrice($or_price);
                                if (is_infinite($or_price) || is_nan($or_price)) {
                                    $CancelItemDetail->setItemPrice('0.00');
                                } else {
                                    $CancelItemDetail->setItemPrice($or_price);
                                }

                                $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                            }

                            $Order->setCreditMemos($CreditMemo->getCreditMemo());
                        }
                    }
                } else {
                    if ($total_refund > 0) {
                        $Order->setIsCreditMemoCreated("1");

                        $ccitemArray = array();
                        $totalccitemqty = 0;
                        $creditMemoID = 0; // Reset for every order in loop
                        $shippingRefunded = 0;
                        $shippingTaxRefunded = 0;

                        foreach ($refunds as $refund) {
                            foreach ($refund->get_items() as $item_id => $refundId) {
                                $RefundItemID = $refundId['product_id'];
                                $qty = abs($refundId['quantity']);

                                $item_total_tax = abs($refundId['total_tax']);
                                // $subtotalprice = abs($refundId['subtotal']);
                                $totalitemprice = abs($refundId['total']);

                                $orderItemID = wc_get_order_item_meta($item_id, '_refunded_item_id', true);
                                if (isset($refundId['variation_id']) && $refundId['variation_id'] != '0') {
                                    $RefundItemvariationID = $refundId['variation_id'];
                                    $productv = get_metadata('post', $RefundItemvariationID);
                                    $sku = $productv['_sku'][0];
                                    $ItemID = $RefundItemvariationID;
                                } else {
                                    $product = get_metadata('post', $RefundItemID);
                                    $sku = $product['_sku'][0];
                                    $ItemID = $RefundItemID;
                                }

                                $product = get_metadata('post', $RefundItemID);
                                $Productname = $product['_sku'][0];
                                if ($Productname == '') {
                                    continue;
                                }

                                $or_qty = wc_get_order_item_meta($orderItemID, '_qty', true);
                                $or_price = floatval(wc_get_order_item_meta($orderItemID, '_line_total', true));

                                $totalccitemqty = $totalccitemqty + $qty;
                                if (array_key_exists($sku, $ccitemArray)) {
                                    $ccitemArray[$sku]["qty"] = $ccitemArray[$sku]["qty"] + $qty;
                                    $ccitemArray[$sku]["itemtaxamount"] = $ccitemArray[$sku]["itemtaxamount"] + $item_total_tax;
                                    $ccitemArray[$sku]["refunditemprice"] = $ccitemArray[$sku]["refunditemprice"] + $totalitemprice;
                                } else {
                                    if ($qty != 0) {
                                        $ccitemArray[$sku]["qty"] = $qty;
                                        $ccitemArray[$sku]["name"] = $Productname;
                                        $ccitemArray[$sku]["ID"] = $ItemID;
                                        // $singleitemprice = round($totalitemprice / $qty, 3);
                                        // $ccitemArray[$sku]["refunditemprice"] = $singleitemprice;
                                        $ccitemArray[$sku]["refunditemprice"] = $totalitemprice;
                                        $ccitemArray[$sku]["itemtaxamount"] = $item_total_tax;
                                        $ccitemArray[$sku]["or_qty"] = $or_qty;
                                        $ccitemArray[$sku]["or_price"] = $or_price;
                                    }
                                }
                            }

                            foreach ($refund->get_items('shipping') as $item_id => $refundId) {
                                $shippingRefunded += abs($refundId->get_total());
                                $shippingTaxRefunded += abs($refundId->get_total_tax());
                            }

                            if ($creditMemoID==0) { // Set to latest refund
                                $creditMemoID = $refund->get_id();
                                $creditMemoDate = date("m-d-Y H:i:s", $refund->get_date_created()->getTimestamp()) ." +0";
                            }
                        }

                        $CreditMemo = new CreditMemo();

                        $CreditMemo->setSubtotal($total_refund);
                        $CreditMemo->setCreditMemoID($creditMemoID);
                        $CreditMemo->setCreditMemoDate($creditMemoDate);

                        foreach ($ccitemArray as $cckey => $ccval) {
                            $CancelItemDetail = new CancelItemDetail();

                            $CancelItemDetail->setItemID($ccval["ID"]);
                            $CancelItemDetail->setItemSku($cckey);
                            $CancelItemDetail->setItemName($ccval["name"]);
                            $CancelItemDetail->setQtyCancel($ccval["qty"]);
                            $CancelItemDetail->setQtyInOrder($ccval["or_qty"]);

                            $perQtyPrice = number_format($ccval["refunditemprice"]/$ccval["qty"], 2, '.', '');
                            $CancelItemDetail->setPriceCancel($perQtyPrice);
                            $CancelItemDetail->setItemPrice($perQtyPrice);

                            $itemTaxAMT = $ccval["itemtaxamount"] ? $ccval["itemtaxamount"] : "0.00";
                            $CancelItemDetail->setRefundItemTaxAmount(round($itemTaxAMT, 2));

                            $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                        }

                        # Orders/Ship refund info
                        if ($shippingRefunded || $shippingTaxRefunded) {
                            $CancelItemDetail = new CancelItemDetail();
                            $CancelItemDetail->setItemID('');
                            $CancelItemDetail->setItemSku('SHIPPING_REFUND');
                            $CancelItemDetail->setItemName('SHIPPING_REFUND');
                            $CancelItemDetail->setQtyCancel('1');
                            $CancelItemDetail->setQtyInOrder('1');
                            $CancelItemDetail->setPriceCancel($shippingRefunded);
                            $CancelItemDetail->setItemPrice($shippingRefunded);
                            $CancelItemDetail->setRefundItemTaxAmount($shippingTaxRefunded);
                            $CreditMemo->setCancelItemDetail($CancelItemDetail->getCancelItemDetail());
                        }

                        $Order->setCreditMemos($CreditMemo->getCreditMemo());
                    }
                }

                # Orders/Bill/CreditCard info
                $Bill = new WG_Bill();
                $CreditCard = new WG_CreditCard();
                $txn = "";
                $txnArray = get_post_meta($order->get_id(), '_transaction_id');

                if (is_array($txnArray) && isset($txnArray[0])) {
                    $txn = $txnArray[0];
                }

                $CreditCard->setTransactionId($txn);
                $CreditCard->getCreditCard();
                $Bill->setCreditCardInfo($CreditCard->getCreditCard());

                $Bill->setPayMethod($order->get_payment_method_title() ? $order->get_payment_method_title() : $order->get_payment_method());
                $Bill->setPayStatus('');
                $Bill->setTitle('');

                #Fixed - Customer first and last Name Is Downloading with Special Character's, While Downloading Orders.
                $Bill->setFirstName(preg_replace('/[^(\x20-\x7F)\x0A\x0D]*/', '', $order->get_billing_first_name()));
                $Bill->setLastName(preg_replace('/[^(\x20-\x7F)\x0A\x0D]*/', '', $order->get_billing_last_name()));
                $Bill->setCompanyName($order->get_billing_company());
                #Fixed - Customer first and last Name Is Downloading with Special Character's, While Downloading Orders.

                #Billing details
                $Bill->setAddress1($order->get_billing_address_1());
                $Bill->setAddress2($order->get_billing_address_2());
                $Bill->setCity($order->get_billing_city());
                $Bill->setState($order->get_billing_state());
                $Bill->setZip($order->get_billing_postcode());
                $Bill->setCountry($order->get_billing_country());
                $Bill->setEmail($order->get_billing_email());
                $Bill->setPhone($order->get_billing_phone());
                $Bill->setPONumber('');
                $Order->setOrderBillInfo($Bill->getBill());

                # Orders/Ship info
                $Ship = new WG_Ship();

                $shipping_method = $shipping_carrier = '';
                $shipping_details = $order->get_shipping_methods();
                if (!empty($shipping_details)) {
                    foreach ($shipping_details as $k => $v) {
                        $shipping_method = ucwords(str_replace('_', ' ', $v['method_id']));
                        $shipping_carrier = $v['name'];
                    }
                }
                $Ship->setShipMethod($shipping_method);
                $Ship->setCarrier($shipping_carrier);
                $Ship->setTrackingNumber('');
                $Ship->setTitle('');
                $Ship->setFirstName($order->get_shipping_first_name());
                $Ship->setLastName($order->get_shipping_last_name());
                $Ship->setCompanyName($order->get_shipping_company());
                $Ship->setAddress1($order->get_shipping_address_1());
                $Ship->setAddress2($order->get_shipping_address_2());
                $Ship->setCity($order->get_shipping_city());
                $Ship->setState($order->get_shipping_state());
                $Ship->setZip($order->get_shipping_postcode());
                $Ship->setCountry($order->get_shipping_country());
                $Ship->setEmail('');
                $Ship->setPhone($order->get_shipping_phone() ? $order->get_shipping_phone() : $order->get_billing_phone());

                $Order->setOrderShipInfo($Ship->getShip());

                // unset($shipping_carrier, $shipping_method);
                if (isset($order->order_custom_fields['_order_items'][0])) {
                    $product_items = $order->order_custom_fields['_order_items'][0];
                    $product_items_arr = unserialize($product_items);
                } else {
                    $product_items_arr = "";
                }

                $total_tax = 0;
                if ($version >= '2.0.0') {
                    foreach ($order->get_items() as $cart_row) {
                        $itemNoteField = array();
                        $Item = new WG_Item();

                        if ($cart_row['variation_id'] > 0) {
                            $_product = get_metadata('post', $cart_row['variation_id']);
                            if (empty($_product['_sku'][0])) {
                                $varsku = get_post_meta($cart_row['product_id'], '_sku');
                                $_product['_sku'][0] = $varsku[0];
                            }
                            if (empty($_product['_length'][0])) {
                                $_length = get_post_meta($cart_row['product_id'], '_length');
                                $_product['_length'][0] = $_length[0];
                            }
                            if (empty($_product['_width'][0])) {
                                $_width = get_post_meta($cart_row['product_id'], '_width');
                                $_product['_width'][0] = $_width[0];
                            }
                            if (empty($_product['_height'][0])) {
                                $_height = get_post_meta($cart_row['product_id'], '_height');
                                $_product['_height'][0] = $_height[0];
                            }
                            if (empty($_product['_weight'][0])) {
                                $_weight = get_post_meta($cart_row['product_id'], '_weight');
                                $_product['_weight'][0] = $_weight[0];
                            }
                        } else {
                            $_product = get_metadata('post', $cart_row['product_id']);
                        }

                        $item_meta = new WC_Order_Item_Product($cart_row['item_meta']);

                        /* Will be use in future when need for custom field */
                        // $item_note = get_post_meta($cart_row['product_id'], 'item_note', true);
                        // $item_vendorText = get_post_meta($cart_row['product_id'], 'item_vendor', true);

                        // $itemNoteField[] = array(
                        //    'FieldName' => 'Item Note',
                        //    'FieldValue' => $item_note,
                        // );

                        // $itemNoteField[] = array(
                        //    'FieldName' => 'Item Vendor',
                        //    'FieldValue' => $item_vendorText,
                        // );

                        // $Item->setCustomFields($itemNoteField);
                        /* Will be use in future when need for custom field */

                        $Item->setItemID($cart_row['product_id']);
                        $Item->setItemCode($_product['_sku'][0] ? $_product['_sku'][0] : $cart_row['name']);

                        $product_fields = $wpdb->get_results("SELECT p.post_title, p.post_content FROM $wpdb->posts p WHERE p.ID = " . $cart_row['product_id'] . "  ", ARRAY_A);

                        $Item->setItemDescription(html_entity_decode(stripslashes($product_fields[0]['post_title']) ? ($product_fields[0]['post_title']) : $cart_row['name']));

                        $desc = "";
                        if ($cart_row['variation_id'] > 0) {
                            $desc = htmlentities(substr(html_entity_decode($_product['_variation_description'][0]), 0, 4000), ENT_QUOTES);
                        } else {
                            $desc = htmlentities(substr(html_entity_decode($product_fields[0]['post_content']), 0, 4000), ENT_QUOTES);
                        }

                        $Item->setItemShortDescr(strip_tags(htmlentities($desc)));
                        unset($desc);

                        // $weight_unit = get_option('woocommerce_weight_unit');
                        // $dimension_unit = get_option('woocommerce_dimension_unit');
                        $Item->setQuantity($cart_row['qty']);

                        $Dimention['Length'] = (float) $_product['_length'][0];
                        $Dimention['Width'] = (float) $_product['_width'][0];
                        $Dimention['Height'] = (float) $_product['_height'][0];
                        // $Dimention['Unit'] = $dimension_unit;
                        $Dimention['Unit'] = 'in';
                        $Item->setDimention($Dimention);

                        if ($cart_row['qty'] > 0) {
                            $unitPrice = $cart_row['line_subtotal'] / $cart_row['qty'];
                        } else {
                            $unitPrice = $cart_row['line_subtotal'];
                        }

                        #$Item->setUnitPrice($unitPrice);
                        if (is_infinite($unitPrice) || is_nan($unitPrice)) {
                            $Item->setUnitPrice('0.00');
                        } else {
                            $Item->setUnitPrice($unitPrice);
                        }

                        // $to_unit = $weight_unit;
                        $to_unit = 'lbs';
                        $weight_in_lbs = wc_get_weight($_product['_weight'][0], $to_unit);
                        $Item->setWeight(round($weight_in_lbs, 4));
                        $Item->setFreeShipping('');
                        $Item->setDiscounted('');
                        $Item->setshippingFreight('');
                        $Item->setWeight_Symbol($weightsymbol);
                        $Item->setWeight_Symbol_Grams($weight_symbol_grams);

                        // Bug Fixed - #225658 - sales tax problem (SM-Item set as Non Taxable but when they are downloading in the orders, they are coming with Taxable code.)
                        if ($cart_row['line_subtotal_tax'] == 0 && $cart_row['line_tax'] == 0) {
                            $Item->setTaxExempt('Y');
                        } elseif ($cart_row['line_subtotal_tax'] != "" && $cart_row['line_tax'] != "") {
                            $Item->setTaxExempt('N');
                        } else {
                            $Item->setTaxExempt('Y');
                        }

                        $Item->setOneTimeCharge('');
                        $Item->setItemTaxAmount($cart_row['line_subtotal_tax']);

                        $Itemoption = new WG_Itemoption();

                        /* Fixed - Size and colour getting download  with the order with extra characters in Webgility */
                        foreach ($_product as $meta_k => $meta_v) {
                            $pos = strpos($meta_k, 'attribute_pa_');

                            if ($pos !== false) {
                                $name = explode("_", $meta_k);
                                $term = get_term_by('slug', $meta_value, esc_attr(str_replace('attribute_pa_', '', $meta_key)));
                                if (!is_wp_error($term) && $term->name) {
                                    $meta_value = $term->name;
                                }

                                #if attrubute has blank value
                                if (empty($meta_v[0]) && isset($item_meta->meta[$name[1]][0])) {
                                    $meta_v[0] = $item_meta->meta[$name[1]][0];
                                }

                                /* #Fixed - Attribute Color not downloading for some items in orders in Webgility */
                                $metaValueHasdash = strpos($meta_v[0], '-');
                                if ($metaValueHasdash === false) {
                                    $Itemoption->setOptionName($name[2]);
                                    $Itemoption->setOptionValue($meta_v[0]);
                                } else {
                                    $words = explode('-', $meta_v[0]);
                                    $Itemoption->setOptionName($name[2]);
                                    $Itemoption->setOptionValue($words[1]);
                                }
                                /* #Fixed - Attribute Color not downloading for some items in orders in Webgility */

                                $Item->setItemOptions($Itemoption->getItemoption());
                            }
                        }
                        /* Fixed - Size and colour getting download with the order with extra characters in Webgility */

                        foreach ($item_meta->meta as $meta_key => $meta_value) {
                            if (!$meta_value || (substr($meta_key, 0, 1) == '_')) {
                                continue;
                            }

                            $meta_key = wp_kses_post($meta_key);
                            // $meta_key = preg_replace('/&#036;/', '', $meta_key);
                            // $meta_key = str_replace('$', '', $meta_key);
                            $meta_key = str_replace('pa_', '', $meta_key);
                            $Itemoption->setOptionName($meta_key);
                            if (is_array($meta_value)) {
                                foreach ($meta_value as $key => $value) {
                                    $Itemoption->setOptionValue(wp_kses_post($value));
                                }
                            } else {
                                $Itemoption->setOptionValue(wp_kses_post($meta_value));
                            }

                            // $Itemoption->setOther1(wp_kses_post( $meta_value ));
                            $Item->setItemOptions($Itemoption->getItemoption());
                        }

                        // CODE UPDATED BECAUSE OF TAX ISSUE WHILE USING DISCOUNT @ 2-SEP-2013
                        // $total_tax = $total_tax + $cart_row['line_subtotal_tax'] + $order->get_shipping_tax();
                        $total_tax = $total_tax + $cart_row['line_tax'];
                        // END OF TAX CODE UPDATE

                        $Order->setOrderItems($Item->getItem());
                    } // end items
                } else {
                    foreach ($product_items_arr as $cart_row) {
                        $Item = new WG_Item();

                        if ($cart_row['variation_id'] > 0) {
                            // $item_price = $_product->sale_price;
                            $_product = new WC_Product_Variation($cart_row['variation_id']);
                        } else {
                            // $item_price = $_product->sale_price;
                            $_product = new WC_Product($cart_row['id']);
                        }

                        $Item->setItemCode($_product->sku ? $_product->sku : $cart_row['name']);
                        // echo "SELECT p.post_title FROM $wpdb->posts p WHERE p.ID = ".$cart_row['id']."  ";
                        $product_fields = $wpdb->get_results("SELECT p.post_title, p.post_content FROM $wpdb->posts p WHERE p.ID = " . $cart_row['id'] . "  ", ARRAY_A);

                        $Item->setItemDescription(html_entity_decode(stripslashes($product_fields[0]['post_title']) ? ($product_fields[0]['post_title']) : $cart_row['name']));

                        $Item->setQuantity($cart_row['qty']);

                        $sql = "SELECT meta_value FROM " . WPSC_TABLE_PRODUCTMETA . " AS meta WHERE meta.product_id = " . $cart_row['prodid'] . " and meta_key='sku'";
                        $product_meta_sku = $wpdb->get_results($sql, ARRAY_A);

                        $Dimention['Length'] = (float) $_product->length;
                        $Dimention['Width'] = (float) $_product->width;
                        $Dimention['Height'] = (float) $_product->height;
                        $Dimention['Unit'] = 'cm';
                        $Item->setDimention($Dimention);

                        if ($cart_row['qty'] > 0) {
                            $unitPrice = $cart_row['line_subtotal'] / $cart_row['qty'];
                        } else {
                            $unitPrice = $cart_row['line_subtotal'];
                        }

                        $Item->setUnitPrice($unitPrice);
                        $to_unit = 'lbs';
                        $weight_in_lbs = wc_get_weight($_product->weight, $to_unit);
                        $Item->setWeight($weight_in_lbs);
                        $Item->setFreeShipping('');
                        $Item->setDiscounted('');
                        $Item->setshippingFreight('');
                        $Item->setWeight_Symbol($weightsymbol);
                        $Item->setWeight_Symbol_Grams($weight_symbol_grams);

                        // Bug Fixed - #225658 - sales tax problem (SM-Item set as Non Taxable but when they are downloading in the orders, they are coming with Taxable code.)
                        if ($cart_row['line_subtotal_tax'] == 0 && $cart_row['line_tax'] == 0) {
                            $Item->setTaxExempt('Y');
                        } elseif ($cart_row['line_subtotal_tax'] != "" && $cart_row['line_tax'] != "") {
                            $Item->setTaxExempt('N');
                        } else {
                            $Item->setTaxExempt('Y');
                        }

                        $Item->setOneTimeCharge('');
                        $Item->setItemTaxAmount($cart_row['line_subtotal_tax']);

                        $Itemoption = new WG_Itemoption();

                        foreach ($cart_row['item_meta'] as $option) {
                            $Itemoption->setOptionName(htmlentities(ucfirst(sanitize_title(str_replace('pa_', '', $option['meta_name'])))));
                            $Itemoption->setOptionValue(htmlentities($option['meta_value']));

                            $Item->setItemOptions($Itemoption->getItemoption());
                        }

                        $total_tax = $total_tax + $cart_row['line_subtotal_tax'];

                        $Order->setOrderItems($Item->getItem());
                    } // end items
                    // Download fee as a line item
                }

                foreach ($order->get_fees() as $key => $order_fee) {
                    if (isset($order_fee['total']) || isset($order_fee['line_total'])) {
                        $Item = new WG_Item();

                        if (!empty($order_fee['total'])) {
                            $total = $order_fee['total'];
                        } elseif (!empty($order_fee['line_total'])) {
                            $total = $order_fee['line_total'];
                        } else {
                            $total = "0.00";
                        }

                        if (isset($order_fee['total_tax']) && $order_fee['total_tax'] != '') {
                            $total_tax = $total_tax + $order_fee['total_tax'];
                        }

                        $Item->setItemCode($order_fee['name']);
                        $Item->setItemDescription($order_fee['name']);
                        $Item->setItemShortDescr($order_fee['name']);
                        $Item->setQuantity(intval(1));
                        $Item->setUnitPrice($total);
                        $Order->setOrderItems($Item->getItem());
                    }
                }

                $charges = new WG_Charges();

                // $order_tot_discount = $order->order_discount ? $order->order_discount : 0.00;
                $order_tot_discount = 0.00;
                if (($order->get_total_discount() !== null) && $order->get_total_discount() > '0.00') {
                    $order_tot_discount = $order_tot_discount + $order->get_total_discount() ? $order->get_total_discount() : 0.00;
                }
                $charges->setDiscount($order_tot_discount);

                $charges->setStoreCredit('0.00');

                #Fixed if order has tax either in string or in array format
                $order_shipping_tax = $order->get_shipping_tax();

                if (is_array($order_shipping_tax)) {
                    $order_total_tax = $order_shipping_tax['total'];
                } else {
                    $order_total_tax = $order->get_shipping_tax();
                }

                $totalTaxWithShipping = floatval($total_tax) + floatval($order_total_tax);

                $charges->setTax($totalTaxWithShipping ? $totalTaxWithShipping : '0.00');

                unset($total_tax);
                // $charges->setTax($total_tax + $order->get_shipping_tax() ? $total_tax + $order->get_shipping_tax() : '0.00');
                #Fixed if order has tax either in string or in array format
                $charges->setShipping($order->get_shipping_total() ? $order->get_shipping_total() : '0.00');
                $charges->setSubTotal($order->get_subtotal() ? $order->get_subtotal() : "0.00");
                $charges->setTotal($order->get_total() ? $order->get_total() : "0.00");

                $Order->setOrderChargeInfo($charges->getCharges());

                $Order->setShippedOn(date("m-d-Y H:i:s", $order->get_date_modified()->getTimestamp()));
                $shipping_method_title = $order->get_shipping_method();
                $Order->setShippedVia($shipping_method_title ? $shipping_method_title : $shipping_method);

                $MaxOrderNoInBatch = $order->get_id();

                $MaxdateNoInBatch = date("Y-m-d H:i:s", $order->get_date_modified()->getTimestamp());
                $Orders->setOrders($Order->getOrder());
            }
        }

        if ($hpos_enabled) {
            $sql = "SELECT COUNT(*) AS total FROM {$wpdb->prefix}wc_orders AS p where p.ID >" . (int) $MaxOrderNoInBatch . "  AND p.date_updated_gmt LIKE '%" . $MaxdateNoInBatch . "%' ORDER BY p.date_updated_gmt, p.ID ASC";
        } else {
            $sql = "SELECT COUNT(*) AS total FROM $wpdb->posts AS p where p.ID >" . (int) $MaxOrderNoInBatch . "  AND p.post_modified_gmt LIKE '%" . $MaxdateNoInBatch . "%' ORDER BY p.post_modified_gmt, p.ID ASC";
        }
        $query = $wpdb->get_results($sql, ARRAY_A);

        if ($query[0]['total'] > 0) {
            $Orders->setMaxOrderNoInBatch($MaxOrderNoInBatch);
        } else {
            $Orders->setMaxOrderNoInBatch("");
        }

        if (isset($download_order_number) && $download_order_number != '') {
            $flagvalue = 'true';
        } else {
            $flagvalue = 'false';
        }

        $Orders->OrderNumberFlag($flagvalue);

        return $this->response($Orders->getOrders());
    } // getOrdersByDateRange

    public function GetImage($username, $password, $data, $storeid = 1, $others) {

        global $wpdb, $wp_query, $table_prefix, $wp_version;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        } else {
            $Items = new WG_Items();
            $Items->setStatusCode('0');
            $Items->setStatusMessage('All Ok');
        }

        $version = $wp_version;

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Items->setStatusCode('9997');
            $Items->setStatusMessage('Unknown request or request not in proper format');
            return $this->response($Items->getItems());
        }

        if (count($requestArray) == 0) {
            $Items->setStatusCode('9996');
            $Items->setStatusMessage('REQUEST tag(s) doesnt have correct input format');
            return $this->response($Items->getItems());
        }

        $itemsCount = 0;
        $itemsProcessed = 0;
        $_err_message_arr = array();

        // Go throught items
        foreach ($requestArray as $kv => $vItem) { // request
            $status = "Success";

            $productID = $vItem['ItemID'];

            $image_types = array(
                "bmp" => "'image/bmp'",
                "gif" => "'image/gif'",
                "ief" => "'image/ief'",
                "jpeg" => "'image/jpeg'",
                "jpg" => "'image/jpeg'",
                "jpe" => "'image/jpeg'",
                "png" => "'image/png'",
                "tiff" => "'image/tiff'",
                "tif" => "'image/tif'",
                "djvu" => "'image/vnd.djvu'",
                "djv" => "'image/vnd.djvu'",
                "wbmp" => "'image/vnd.wap.wbmp'",
                "ras" => "'image/x-cmu-raster'",
                "pnm" => "'image/x-portable-anymap'",
                "pbm" => "'image/x-portable-bitmap'",
                "pgm" => "'image/x-portable-graymap'",
                "ppm" => "'image/x-portable-pixmap'",
                "rgb" => "'image/x-rgb'",
                "xbm" => "'image/x-xbitmap'",
                "xpm" => "'image/x-xpixmap'",
                "xwd" => "'image/x-windowdump'"
            );
            $image_types = implode(",", $image_types);

            if ($version > '3.7.8') {
                $sql = "SELECT SQL_CALC_FOUND_ROWS  posts.* FROM " . $table_prefix . "posts as posts  WHERE posts.post_parent = '" . $productID . "' AND posts.post_type ='attachment' AND posts.post_mime_type IN (" . $image_types . ")";
            } else {
                $sql = "SELECT DISTINCT * FROM " . WPSC_TABLE_PRODUCT_IMAGES . " AS products WHERE products.product_id='" . $productID . "'";
            }

            $product_list = $wpdb->get_results($sql, ARRAY_A);
            if ($product_list[0]['guid']) {
                $responseArray = array();
                $responseArray['ItemID'] = $productID;
                $responseArray['Image'] = base64_encode(file_get_contents($product_list[0]['guid']));

                $Items->setItems($responseArray);
                break;
            } else {
                break;
            }

            unset($product_list);
        } //End of Items foreach loop

        return $this->response($Items->getItems());
    }

    public function addItemImage($itemid, $image, $image2, $storeid = 1) {

        global $wpdb, $version;

        include_once ABSPATH . 'wp-admin/includes/image.php';

        $uploads = wp_upload_dir();

        define('DIR_IMAGE_FOR_UPLOAD', $uploads['path'] . '/');
        // echo DIR_IMAGE_FOR_UPLOAD;
        chmod(DIR_IMAGE_FOR_UPLOAD, 0755);
        // $url = 'http://'.$_SERVER['HTTP_HOST'].'/'.substr($_SERVER['SCRIPT_NAME'], 1, strpos(substr($_SERVER['SCRIPT_NAME'],1), '/')).'/?wpsc-product=';
        $url = 'http://' . $_SERVER['HTTP_HOST'] . '/' . substr($_SERVER['SCRIPT_NAME'], 1, strpos(substr($_SERVER['SCRIPT_NAME'], 1), '/')) . '/?p=';

        // $Items = new WG_Items();

        $timestamp_valu = time();

        $image_name = $timestamp_valu . '.jpg';
        if ($image2) {
            $image_name2 = $timestamp_valu . '1' . '.jpg';
            $str2 = base64_decode($image2);
        }
        //Base 64 encoded string $image
        $str = base64_decode($image);

        if (substr(decoct(fileperms(DIR_IMAGE_FOR_UPLOAD)), 2) == '755') {
            $fp = fopen(DIR_IMAGE_FOR_UPLOAD . $image_name, 'w+');
            fwrite($fp, $str);
            fclose($fp);
            if ($image2) {
                $fp2 = fopen(DIR_IMAGE_FOR_UPLOAD . $image_name2, 'w+');

                fwrite($fp2, $str2);
                fclose($fp2);

                $attachment2 = array(
                    'post_mime_type' => 'image/jpeg',
                    'guid' => $url . $timestamp_valu . '1',
                    'post_parent' => $itemid,
                    'post_title' => $timestamp_valu . '1',
                    'post_content' => 'Product image post !!!',
                    'post_type' => "attachment",
                    'post_status' => 'inherit',
                );

                // Save the data
                $postID2 = wp_insert_post($attachment2, $file, $itemid);
            }

            #create the item's image
            // Construct the attachment array
            $attachment = array(
                'post_mime_type' => 'image/jpeg',
                'guid' => $url . $timestamp_valu,
                'post_parent' => $itemid,
                'post_title' => $timestamp_valu,
                'post_content' => 'Product image post !!!',
                'post_type' => "attachment",
                'post_status' => 'inherit',
            );

            // Save the data
            $postID = wp_insert_post($attachment, $file, $itemid);

            $time = current_time('mysql');
            $y = substr($time, 0, 4);
            $m = substr($time, 5, 2);
            $subdir = "$y/$m";

            add_post_meta($postID, '_wp_attached_file', $subdir . '/' . $image_name);
            add_post_meta($itemid, '_thumbnail_id', $postID);

            if ($image2) {
                add_post_meta($postID2, '_wp_attached_file', $subdir . '/' . $image_name2);
                add_post_meta($itemid, '_product_image_gallery', $postID2);

                $file2 = DIR_IMAGE_FOR_UPLOAD . $image_name2;
                wp_generate_attachment_metadata($postID2, $file2);

                get_post_meta($postID2 + 1, '_wpsc_selected_image_size', true);
            }

            $file = DIR_IMAGE_FOR_UPLOAD . $image_name;
            wp_generate_attachment_metadata($postID, $file);

            get_post_meta($postID + 1, '_wpsc_selected_image_size', true);

            $image_node_array = array();
            $ImagePath = 'http://' . $_SERVER['HTTP_HOST'] . '/' . substr($_SERVER['SCRIPT_NAME'], 1, strpos(substr($_SERVER['SCRIPT_NAME'], 1), '/')) . '/wp-content/uploads' . $subdir . '/' . $image_name;

            $image_node_array['ItemImages'] = array('ItemID' => $itemid, 'ItemImageID' => $itemid, 'ItemImageFileName' => $image_name, 'ItemImageUrl' => $ImagePath);

            $image_node_array2 = array();
            $ImagePath2 = 'http://' . $_SERVER['HTTP_HOST'] . '/' . substr($_SERVER['SCRIPT_NAME'], 1, strpos(substr($_SERVER['SCRIPT_NAME'], 1), '/')) . '/wp-content/uploads' . $subdir . '/' . $image_name2;

            $image_node_array2['ItemImages'] = array('ItemID' => $itemid, 'ItemImageID' => $itemid, 'ItemImageFileName' => $image_name2, 'ItemImageUrl' => $ImagePath2);

            ########################################################################################
            $imagedetail = getimagesize($file);

            $attachment_id = $postID;
            $width = $imagedetail[0];
            $height = $imagedetail[1];
            $intermediate_size = '';

            if ((($width >= 10) && ($height >= 10)) && (($width <= 1024) && ($height <= 1024))) {
                $intermediate_size = "wpsc-{$width}x{$height}";
                $generate_thumbnail = true;
            } else {
                $generate_thumbnail = false;
            }

            // If the attachment ID is greater than 0, and the width and height is greater than or equal to 10, and less than or equal to 1024
            if (($attachment_id > 0) && ($intermediate_size != '')) {
                // Get all the required information about the attachment
                $uploads = wp_upload_dir();

                $image_meta = get_post_meta($attachment_id, '');
                $file_path = get_attached_file($attachment_id);

                wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $file_path));

            }

            if ($file2 != '') {
                $imagedetail2 = getimagesize($file2);
            } else {
                $imagedetail2 = array();
            }

            $attachment_id2 = $postID2;
            $width2 = $imagedetail2[0];
            $height2 = $imagedetail2[1];
            $intermediate_size2 = '';

            if ((($width2 >= 10) && ($height2 >= 10)) && (($width2 <= 1024) && ($height2 <= 1024))) {
                $intermediate_size2 = "wpsc-{$width2}x{$height2}";
                $generate_thumbnail2 = true;
            } else {
                $generate_thumbnail2 = false;
            }

            // If the attachment ID is greater than 0, and the width and height is greater than or equal to 10, and less than or equal to 1024
            if (($attachment_id2 > 0) && ($intermediate_size2 != '')) {
                // Get all the required information about the attachment
                $uploads2 = wp_upload_dir();

                $image_meta = get_post_meta($attachment_id2, '');
                $file_path2 = get_attached_file($attachment_id2);

                wp_update_attachment_metadata($attachment_id2, wp_generate_attachment_metadata($attachment_id2, $file_path2));
            }
            ###########################################################################################

            return true;
        } else {
            return false;
        }

        return $this->response($Items->getItems());
    }

    #
    # Function to add the product in the store which found in QB
    #
    public function addProduct($username, $password, $data) {

        global $wpdb, $version;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        } else {
            $Items = new WG_Items();
            $Items->setStatusCode('0');
            $Items->setStatusMessage('All Ok');
        }

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Items->setStatusCode('9997');
            $Items->setStatusMessage('Unknown request or request not in proper format');
            return $this->response($Items->getItems());
        }

        if (count($requestArray) == 0) {
            $Items->setStatusCode('9996');
            $Items->setStatusMessage('REQUEST tag(s) doesnt have correct input format');
            return $this->response($Items->getItems());
        }

        $itemsCount = 0;
        $itemsProcessed = 0;
        $_err_message_arr = array();

        // Go throught items
        $user = wp_authenticate_username_password('WP_User', $username, $password);
        $userID = $user->data->ID;

        $categories_arr = get_terms('product_cat', 'orderby=name&hide_empty=0');
        $Item = new WG_Item();
        $weight_unit = get_option('woocommerce_weight_unit');
        $to_unit = $weight_unit;
        foreach ($requestArray as $kv => $vItem) { // request
            $Item = new WG_Item();
            $Item->setStatus("Success");

            $itemsCount++;
            $productcode = htmlentities($vItem['ItemCode']);
            $product = htmlentities($vItem['ItemName']);
            $descr = $vItem['ItemDesc'];
            $free_shipping = $vItem['FreeShipping'];
            $free_tax = $vItem['TaxExempt'];
            $tax_id = $vItem['TaxID'];
            $item_match = $vItem['ItemMatchBy'];
            $manufacturerid = $vItem['ManufacturerID'];
            $avail_qty = $vItem['Quantity'];
            $price = $vItem['ListPrice'];
            $weight = wc_get_weight($vItem['Weight'], $to_unit, 'lbs');
            unset($categoryid);

            if (is_array($vItem['Categories'])) {
                $arrayCategories = $vItem['Categories'];
                $categoryid = array();
                foreach ($arrayCategories as $k3 => $vCategories) { // Categories
                    if (isset($vCategories['CategoryId']) && $vCategories['CategoryId'] != '') {
                        $taxnomyDetail = get_term($vCategories['CategoryId'], 'product_cat');
                        $categoryid[] = $taxnomyDetail->term_taxonomy_id;
                    }
                }
            }

            $now = time();
            $lock = "$now:$userID";

            if ($avail_qty > 0) {
                $stock_status = 'instock';
            } else {
                $stock_status = 'outofstock';
            }

            $sql = "SELECT id,post_title FROM $wpdb->posts p WHERE post_type = 'product' AND post_title='" . addslashes($product) . "'";
            $product_list = $wpdb->get_results($sql);
            // print_r($product_list); die;
            $product_ID = $product_list[0]->id;
            if ($vItem['ItemStatus'] == '1') {
                $item_status = 'publish';
            } else {
                $item_status = 'draft';
            }

            if ($product_ID == "") {
                $date = date('Y-m-d H:i:s');
                $post_data['post_title'] = $product;
                $post_data['post_content'] = $descr;
                // $post_data['post_date'] = $date;
                // $post_data['post_modified'] = $date;
                $post_data['original_post_status'] = 'auto-draft';
                $post_data['post_status'] = $item_status;
                $post_data['post_type'] = 'product';
                $post_data['product-type'] = 'simple';
                $post_data['post_author'] = $userID;
                $post_data['post_name'] = '';
                $post_data['guid'] = '';
                $post_data['tax_input']['product_cat'] = $categoryid;

                $product_ID = wp_insert_post($post_data, $wp_error = false);

                // add_meta( $product_ID );
                add_post_meta($product_ID, '_edit_last', $userID);

                $attributes = (array) maybe_unserialize(get_post_meta($product_ID, '_product_attributes', false));

                /* #00139918 - Customisation- Transfer Size, MFg and gauge information at store */
                if (isset($vItem['CustomFields']) && $vItem['CustomFields'] != '') {
                    $att_customField = json_decode($vItem['CustomFields']);
                    $_product_attributes = array();

                    foreach ($att_customField as $itemattri) {
                        $attribute_name = "pa_" . strtolower($itemattri->FieldName);
                        $attribute_value = $itemattri->FieldValue;
                        // Appending term to the object/product.
                        $term_taxonomy_ids = wp_set_object_terms($product_ID, $attribute_value, $attribute_name, true);

                        $attribute_name = array(
                            'name' => $attribute_name,
                            'value' => $attribute_value,
                            'is_visible' => '1',
                            'is_variation' => '0',
                            'is_taxonomy' => '1',
                        );
                        // First getting the Post Meta
                        $_product_attributes[] = $attribute_name;
                    }

                    // Updating the Post Meta
                    update_post_meta($product_ID, '_product_attributes', $_product_attributes);
                }
                /* #00139918 - Customisation- Transfer Size, MFg and gauge information at store */

                if (isset($vItem['ItemVariants']) && $vItem['ItemVariants'] != null) {
                    if (sizeof($vItem['ItemVariants']) > 0) {
                        $post_meta = array(
                            '_edit_lock' => $lock,
                            '_sku' => $productcode,
                            '_regular_price' => $price,
                            #'_sale_price' =>  $price,
                            '_price' => $price,
                            '_tax_status' => '',
                            '_tax_class' => $tax_id,
                            '_visibility' => $vItem['ItemVisibility'],
                            '_purchase_note' => '',
                            '_featured' => 'no',
                            '_weight' => $weight,
                            '_length' => '',
                            '_width' => '',
                            '_height' => '',
                            '_product_attributes' => $attributes,
                            '_downloadable' => 'no',
                            '_virtual' => 'no',
                            '_sale_price_dates_from' => $now,
                            '_sale_price_dates_to' => '',
                            '_backorders' => 'no',
                        );
                    }
                } else {
                    $post_meta = array(
                        '_edit_lock' => $lock,
                        '_sku' => $productcode,
                        '_regular_price' => $price,
                        #'_sale_price' =>  $price,
                        '_price' => $price,
                        '_tax_status' => '',
                        '_tax_class' => $tax_id,
                        '_visibility' => $vItem['ItemVisibility'],
                        '_purchase_note' => '',
                        '_featured' => 'no',
                        '_weight' => $weight,
                        '_length' => '',
                        '_width' => '',
                        '_height' => '',
                        '_product_attributes' => $attributes,
                        '_downloadable' => 'no',
                        '_virtual' => 'no',
                        '_sale_price_dates_from' => $now,
                        '_sale_price_dates_to' => '',
                        '_stock' => $avail_qty,
                        '_stock_status' => $stock_status,
                        '_backorders' => 'no',
                        '_manage_stock' => 'yes'
                    );
                }

                foreach ($post_meta as $key => $value) {
                    // update_post_meta($product_ID, $key, $value);
                    add_post_meta($product_ID, $key, $value);
                }

                foreach ($categoryid as $category) {
                    $wpdb->insert($wpdb->term_relationships, array('object_id' => $product_ID, 'term_taxonomy_id' => $category));
                }

                ## product type is simple
                $pro_type = $wpdb->get_results("SELECT term_id FROM $wpdb->terms WHERE name = 'simple' AND slug ='simple'");
                if (!empty($pro_type[0]->term_id)) {
                    $wpdb->insert($wpdb->term_relationships, array('object_id' => $product_ID, 'term_taxonomy_id' => $pro_type[0]->term_id));
                } else {
                    $wpdb->insert($wpdb->term_relationships, array('object_id' => $product_ID, 'term_taxonomy_id' => '3'));
                }

                $Item->setStatus("Success");
                $Item->setProductID($product_ID);
                $Item->setSku($productcode);
                $Item->setProductName($product);

                if (isset($vItem['ItemVariants']) && $vItem['ItemVariants'] != null) {
                    if (sizeof($vItem['ItemVariants']) > 0) {
                        wp_set_object_terms($product_ID, 'variable', 'product_type');
                        $save_array = array();
                        $name = "";

                        foreach ($vItem['ItemVariants'] as $kv => $Itemvariants) {
                            $variation = array(
                                'post_title' => 'Product #' . $product_ID . ' Variation',
                                'post_content' => '',
                                'post_status' => 'publish',
                                'post_author' => get_current_user_id(),
                                'post_parent' => $product_ID,
                                'post_type' => 'product_variation',
                            );

                            $variation_id = wp_insert_post($variation);

                            update_post_meta($variation_id, '_sku', $Itemvariants['ItemCode']);
                            update_post_meta($variation_id, '_stock', $Itemvariants['Quantity']);
                            update_post_meta($variation_id, '_price', $Itemvariants['UnitPrice']);
                            update_post_meta($variation_id, '_regular_price', $Itemvariants['UnitPrice']);

                            $variantWeight = wc_get_weight($Itemvariants['Weight'], $to_unit, 'lbs');
                            update_post_meta($variation_id, '_weight', $variantWeight);

                            update_post_meta($variation_id, '_manage_stock', 'yes');
                            if ($Itemvariants['Quantity'] > 0) {
                                update_post_meta($variation_id, '_stock_status', 'instock');
                            } else {
                                update_post_meta($variation_id, '_stock_status', 'outofstock');
                            }

                            $Variant = new WG_Variant();
                            $Variant->setStatus('Success');
                            $Variant->setVarientID($variation_id);
                            $Variant->setVariantSku(htmlentities($Itemvariants['ItemCode']));
                            //$Variant->setProductName(htmlentities($product));
                            $Item->setItemVariants($Variant->getVariant());

                            $br = 0;

                            $all_options = '';

                            $attributes = (array) maybe_unserialize(get_post_meta($product_ID, '_product_attributes', false));
                            foreach ($Itemvariants['ItemOptions'] as $k => $optionsTag) {
                                $value = "";
                                if ($optionsTag['OptionName'] && $optionsTag['OptionName'] != '') {
                                    wp_set_object_terms($product_ID, '', $optionsTag['OptionName']);
                                }
                                $attribute_field_name = 'attribute_' . sanitize_title($optionsTag['OptionName']);
                                update_post_meta($variation_id, $attribute_field_name, $optionsTag['OptionValue']);
                                // foreach($attributes[0] as $k)
                                if ($optionsTag['OptionValue'] && $optionsTag['OptionValue'] != '') {
                                    if (array_key_exists($optionsTag['OptionName'], $attributes[0])) {
                                        $option_val = explode("|", $attributes[0][$optionsTag['OptionName']]['value']);

                                        if (!in_array($optionsTag['OptionValue'], $option_val)) {
                                            if ($attributes[0][$optionsTag['OptionName']]['value']) {
                                                $attributes[0][$optionsTag['OptionName']]['value'] = $attributes[0][$optionsTag['OptionName']]['value'] . "|" . $optionsTag['OptionValue'];
                                            } else {
                                                $attributes[0][$optionsTag['OptionName']]['value'] = $optionsTag['OptionValue'];
                                            }
                                        }
                                    } else {
                                        $thedata = array($optionsTag['OptionName'] => array(
                                            'name' => $optionsTag['OptionName'],
                                            'value' => $optionsTag['OptionValue'],
                                            'is_visible' => '1',
                                            'is_variation' => '1',
                                            'is_taxonomy' => '0',
                                        ));

                                        $attributes[0] = array_merge($attributes[0], $thedata);
                                    }
                                }
                                $name = $optionsTag['OptionName'];
                                $br++;
                            }

                            update_post_meta($product_ID, '_product_attributes', $attributes[0]);

                            $b++;
                        }
                    }
                }
                update_post_meta($product_ID, '_visibility', $vItem['ItemVisibility']);
                update_post_meta($product_ID, '_stock_status', 'instock');
                // #Calling function for add image
                if ($vItem['Image']) {
                    $this->addItemImage($product_ID, $vItem['Image'], $vItem['Image2'], $storeid = 1);
                }

                $Items->setItems($Item->getItem());
            } else {
                $post_id = intval($product_ID);

                if (isset($vItem['ItemVariants']) && $vItem['ItemVariants'] != null) {
                    if (sizeof($vItem['ItemVariants']) > 0) {
                        wp_set_object_terms($product_ID, 'variable', 'product_type');
                        $save_array = array();
                        $name = "";

                        foreach ($vItem['ItemVariants'] as $kv => $Itemvariants) {
                            $variation = array(
                                'post_title' => 'Product #' . $product_ID . ' Variation',
                                'post_content' => '',
                                'post_status' => 'publish',
                                'post_author' => get_current_user_id(),
                                'post_parent' => $product_ID,
                                'post_type' => 'product_variation',
                            );

                            $variation_id = wp_insert_post($variation);

                            update_post_meta($variation_id, '_sku', $Itemvariants['ItemCode']);
                            update_post_meta($variation_id, '_stock', $Itemvariants['Quantity']);
                            update_post_meta($variation_id, '_price', $Itemvariants['UnitPrice']);
                            update_post_meta($variation_id, '_regular_price', $Itemvariants['UnitPrice']);
                            update_post_meta($variation_id, '_manage_stock', 'yes');
                            if ($Itemvariants['Quantity'] > 0) {
                                update_post_meta($variation_id, '_stock_status', 'instock');
                            } else {
                                update_post_meta($variation_id, '_stock_status', 'outofstock');
                            }

                            $Variant = new WG_Variant();
                            $Variant->setStatus('Success');
                            $Variant->setVarientID($variation_id);
                            $Variant->setVariantSku(htmlentities($Itemvariants['ItemCode']));
                            $Item->setItemVariants($Variant->getVariant());

                            $br = 0;

                            $all_options = '';

                            $attributes = (array) maybe_unserialize(get_post_meta($product_ID, '_product_attributes', false));
                            foreach ($Itemvariants['ItemOptions'] as $k => $optionsTag) {
                                $value = "";
                                if ($optionsTag['OptionName'] && $optionsTag['OptionName'] != '') {
                                    wp_set_object_terms($product_ID, '', $optionsTag['OptionName']);
                                }
                                $attribute_field_name = 'attribute_' . sanitize_title($optionsTag['OptionName']);
                                update_post_meta($variation_id, $attribute_field_name, $optionsTag['OptionValue']);
                                //foreach($attributes[0] as $k)
                                if ($optionsTag['OptionValue'] && $optionsTag['OptionValue'] != '') {
                                    if (array_key_exists($optionsTag['OptionName'], $attributes[0])) {
                                        $option_val = explode("|", $attributes[0][$optionsTag['OptionName']]['value']);

                                        if (!in_array($optionsTag['OptionValue'], $option_val)) {
                                            if ($attributes[0][$optionsTag['OptionName']]['value']) {
                                                $attributes[0][$optionsTag['OptionName']]['value'] = $attributes[0][$optionsTag['OptionName']]['value'] . "|" . $optionsTag['OptionValue'];
                                            } else {
                                                $attributes[0][$optionsTag['OptionName']]['value'] = $optionsTag['OptionValue'];
                                            }
                                        }
                                    } else {
                                        $thedata = array($optionsTag['OptionName'] => array(
                                            'name' => $optionsTag['OptionName'],
                                            'value' => $optionsTag['OptionValue'],
                                            'is_visible' => '1',
                                            'is_variation' => '1',
                                            'is_taxonomy' => '0',
                                        ));

                                        $attributes[0] = array_merge($attributes[0], $thedata);
                                    }
                                }
                                $name = $optionsTag['OptionName'];
                                $br++;
                            }

                            update_post_meta($product_ID, '_product_attributes', $attributes[0]);

                            $b++;
                        }
                    } else {
                        $Item->setStatus("Product Already Exists - " . $product);
                        $Item->setProductID($product_ID);
                        $Item->setSku($productcode);
                        $Item->setProductName($product);
                    }
                } else {
                    $Item->setStatus("Product Already Exists - " . $product);
                    $Item->setProductID($product_ID);
                    $Item->setSku($productcode);
                    $Item->setProductName($product);
                }
                update_post_meta($product_ID, '_visibility', $vItem['ItemVisibility']);
                update_post_meta($product_ID, '_stock_status', 'instock');
                // #Calling function for add image
                if ($vItem['Image']) {
                    $this->addItemImage($product_ID, $vItem['Image'], $vItem['Image2'], $storeid = 1);
                }

                $Items->setItems($Item->getItem());
            }

        } //End of Items foreach loop

        return $this->response($Items->getItems());
    } //addProduct

    #
    # Update Orders shipping status method
    # Will update Order Notes and tracking number of  order
    # Input parameter Username,Password, array (OrderID,ShippedVia,ServiceUsed,TrackingNumber,Notes)
    # Wordpress does not support status update emails. So email for status updation would not be sent from here.
    #
    public function UpdateOrdersShippingStatus($username, $password, $data, $statustype, $others) {
        global $wpdb, $download_order_number;

        #check for authorisation
        $status = $this->auth_user($username, $password, $xmlResponse, $root);
        if ($status != '0') {
            return $status;
        }

        // set current user
        if (preg_match('/\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/si', $username)) {
            $user = get_user_by('email', $username);
        } else {
            $user = get_user_by('login', $username);
        }
        if(isset($user->ID)) {
            wp_set_current_user($user->ID);
        }

        $plugins = get_option('active_plugins');
        $sequential_order_numbers_plugin = 'woocommerce-sequential-order-numbers/woocommerce-sequential-order-numbers.php';
        $sequential_order_numbers_plugin_pro = 'woocommerce-sequential-order-numbers-pro/woocommerce-sequential-order-numbers-pro.php';

        $Orders = new WG_Orders();

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Orders->setStatusCode("9997");
            $Orders->setStatusMessage("Unknown request or request not in proper format");
            return $this->response($Orders->getOrders());
            exit();
        }

        if (count($requestArray) == 0) {
            $Orders->setStatusCode("9996");
            $Orders->setStatusMessage("REQUEST array(s) doesnt have correct input format");
            return $this->response($Orders->getOrders());
            exit();
        }

        $Orders->setStatusCode("0");
        $Orders->setStatusMessage("All Ok");

        if ($requestArray[0]['IsCreateRefund'] == 1) {
            $orderrefund = $this->CreateOrderRefund($username, $password, $requestArray);
            $Order = new WG_Order();
            $Order->setOrderID($orderrefund['OrderID']);
            $Order->setStatus($orderrefund['result']);
            $Order->setOrderNotes('');
            $Order->setLastModifiedDate($orderrefund['last_modfied_date']);
            $Order->setOrderStatus($orderrefund['OrderStatus']);
            $Orders->setOrders($Order->getOrder());
        } else {
            foreach ($requestArray as $k2 => $v) { // request
                $order = [];
                foreach ($v as $k3 => $v3) {
                    $order[$k3] = $v3;
                }

                if ($download_order_number == true) {
                    // $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                    if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                        $order_id = wc_seq_order_number_pro()->find_order_by_order_number($order['OrderID']);
                    } elseif (in_array($sequential_order_numbers_plugin, $plugins)) {
                        $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                    } else {
                        $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                    }
                } else {
                    $order_id = $order['OrderID'];
                }

                if (empty($order_id)) {
                    echo "Invalid Order-" . $order['OrderID'];
                    exit;
                }
                // die($order_id);

                # Check for record Existence for the Order ID
                try {
                    $wcOrder = new WC_Order($order_id);
                } catch (Exception $e) {
                    $result = 'Order not found';
                    $Orders->setStatusCode("9997");
                    $Orders->setStatusMessage("Order not exist at store!!");
                    return $this->response($Orders->getOrders());exit();
                }

                $update_note = $order['UpdateOrderNote'];
                $is_customer_note = $order['IsNotifyCustomer'] == 'Y' ? 1 : 0;

                $note_id = 0;
                if ($update_note == "Y") {
                    if (isset($order['OrderNotes']) && $order['OrderNotes'] != '') {
                        $note_id = $wcOrder->add_order_note($order['OrderNotes'], $is_customer_note);
                        $result = 'Success';
                    } else {
                        // $result = 'Error';
                    }
                } else {
                    $info = "\nOrder shipped ";

                    if ($order['ShippedOn'] != "") {
                        $info .= " on " . substr($order['ShippedOn'], 0, 10);
                    }

                    if ($order['ServiceUsed'] != "") {
                        $info .= ". " . $order['ServiceUsed'];
                    }

                    if ($order['TrackingNumber'] != "") {
                        $info .= " Tracking Number is: " . $order['TrackingNumber'] . ".";
                    }

                    if ((!isset($note_val) && $note_val == "")) {
                        if ($order['OrderNotes'] != "") {
                            $info .= " \n" . $order['OrderNotes'];
                        } else {
                            // $result = 'Order notes should not be empty!';
                            // $Orders->setStatusCode("9997");
                            // $Orders->setStatusMessage("Order notes should not be empty!");
                            // return $this->response($Orders->getOrders());exit();
                        }
                    }

                    $set_status = '';
                    $orderStatus = wc_get_order_statuses();
                    foreach ($orderStatus as $id => $name) {
                        if ($name == ucfirst($order['OrderStatus'])) {
                            $set_status = $id;
                        }
                    }

                    if ($set_status != '') {
                        $wcOrder->update_status($set_status, '', true);

                        $note_id = $wcOrder->add_order_note($info, $is_customer_note);

                        $result = 'Success';
                    } else {
                        $result = 'Order status does not exist';
                        $Orders->setStatusCode("9997");
                        $Orders->setStatusMessage("Order status does not exist at store!!");
                        return $this->response($Orders->getOrders());exit();
                    }
                }

                $orderNote = [];
                if ($note_id) {
                    $note = get_comment( $note_id );
                    $last_modfied_date = date("m-d-Y H:i:s", strtotime($note->comment_date_gmt));
                    $orderNote = [$note->comment_content];
                } else {
                    $last_modfied_date = date("m-d-Y H:i:s", strtotime(current_time('mysql', 1)));
                    $ordreNotesArr = $wpdb->get_results("SELECT comment_content FROM $wpdb->comments c WHERE c.comment_post_ID = " . $order_id . " ORDER BY c.comment_date DESC ", ARRAY_A);
                    foreach ($ordreNotesArr as $k => $Notes) {
                        $orderNote = [$Notes['comment_content']];
                        $last_modfied_date = date("m-d-Y H:i:s", strtotime($Notes['comment_date_gmt']));
                        break;
                    }
                }

                $Order = new WG_Order();
                $Order->setOrderID($order['OrderID']);
                $Order->setStatus($result);

                if (isset($orderNote[0]) && $orderNote[0] != '') {
                    $Order->setOrderNotes($orderNote[0]);
                }

                $Order->setLastModifiedDate($last_modfied_date);
                $Order->setOrderStatus($order['OrderStatus']);
                $Orders->setOrders($Order->getOrder());
            }
        }

        return $this->response($Orders->getOrders());
    } //UpdateOrdersShippingStatus

    public function UpdateOrdersStatusAcknowledge($username, $password, $data, $statustype) {

        global $wpdb, $download_order_number;

        #check for authorisation
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        // set current user
        if (preg_match('/\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/si', $username)) {
            $user = get_user_by('email', $username);
        } else {
            $user = get_user_by('login', $username);
        }
        if(isset($user->ID)) {
            wp_set_current_user($user->ID);
        }

        $plugins = get_option('active_plugins');
        $sequential_order_numbers_plugin = 'woocommerce-sequential-order-numbers/woocommerce-sequential-order-numbers.php';
        $sequential_order_numbers_plugin_pro = 'woocommerce-sequential-order-numbers-pro/woocommerce-sequential-order-numbers-pro.php';

        $Orders = new WG_Orders();

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Orders->setStatusCode("9997");
            $Orders->setStatusMessage("Unknown request or request not in proper format");
            return $this->response($Orders->getOrders());
            exit();
        }

        if (count($requestArray) == 0) {
            $Orders->setStatusCode("9996");
            $Orders->setStatusMessage("REQUEST array(s) doesnt have correct input format");
            return $this->response($Orders->getOrders());
            exit();
        }

        $Orders->setStatusCode("0");
        $Orders->setStatusMessage("All Ok");

        foreach ($requestArray as $k2 => $v) { // request
            $order = [];
            foreach ($v as $k3 => $v3) {
                $order[$k3] = $v3;
            }

            if ($download_order_number == true) {
                // $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                if (in_array($sequential_order_numbers_plugin_pro, $plugins)) {
                    $order_id = wc_seq_order_number_pro()->find_order_by_order_number($order['OrderID']);
                } elseif (in_array($sequential_order_numbers_plugin, $plugins)) {
                    $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                } else {
                    $order_id = wc_sequential_order_numbers()->find_order_by_order_number($order['OrderID']);
                }
            } else {
                $order_id = $order['OrderID'];
            }

            if (empty($order_id)) {
                echo "Invalid Order-" . $order['OrderID'];
                exit;
            }

            $notesmsg = "Order status changed to " . $order['OrderStatus'] . ".";

            # Check for record Existence for the Order ID
            try {
                $wcOrder = new WC_Order($order_id);
            } catch (Exception $e) {
                $result = 'Order not found #' . $order_id;
                $Orders->setStatusCode("9997");
                $Orders->setStatusMessage("Order not exist at store!!");
                return $this->response($Orders->getOrders());exit();
            }

            $status_arr = array();
            $orderStatus = wc_get_order_statuses();
            $set_status = '';
            foreach ($orderStatus as $id => $name) {
                if (ucwords($name) == ucwords($order['OrderStatus'])) { //changes due to 2.2.10 version
                    $set_status = $id;
                }
            }

            if ($set_status != '') {
                $wcOrder->update_status($set_status, $notesmsg, true);
                $result = 'Success';
            } else {
                $result = "Invalid Order Status-" . $order['OrderStatus'] . " For Order #" . $order_id;
            }

            $last_modfied_date = date("m-d-Y H:i:s", strtotime(current_time('mysql', 1)));

            $ordreNotesArr = $wpdb->get_results("SELECT comment_content  FROM $wpdb->comments c WHERE c.comment_post_ID  = " . $order_id . " ORDER BY c.comment_date DESC ", ARRAY_A);
            foreach ($ordreNotesArr as $k => $Notes) {
                $orderNote[] = $Notes['comment_content'];
                break;
            }

            $Order = new WG_Order();
            $Order->setOrderID($order['OrderID']);
            $Order->setStatus($result);
            $Order->setOrderNotes($orderNote[0]);
            $Order->setLastModifiedDate($last_modfied_date);
            $Order->setOrderStatus($order['OrderStatus']);
            $Orders->setOrders($Order->getOrder());
        }

        return $this->response($Orders->getOrders());
    }

    public function getCustomersNew($username, $password, $datefrom, $customerid, $limit, $storeid = 1, $others) {

        global $wpdb;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $datefrom = $datefrom ? $datefrom : 0;

        $Customers = new WG_Customers();
        $customer_metakey = $wpdb->prefix . "capabilities";

        $start_no = 0;
        // $user_arr = array();
        $query_args = array(
            'fields' => 'ID',
            'role' => 'customer',
            'orderby' => 'registered',
        );
        $userCountQry = new WP_User_Query($query_args);
        $customer_count = $userCountQry->get_total();

        $customersArray = $wpdb->get_results("SELECT $wpdb->users.*, meta_value FROM $wpdb->users, $wpdb->usermeta WHERE {$wpdb->users}.user_status = '0' AND {$wpdb->users}.ID = {$wpdb->usermeta}.user_id AND meta_key = '" . $customer_metakey . "' AND {$wpdb->users}.ID >" . intval($customerid) . " AND meta_value REGEXP 'customer' ORDER BY {$wpdb->usermeta}.user_id LIMIT " . $start_no . "," . $limit . "");

        $no_customer = false;
        if ($customer_count < 0) {
            $no_customer = true;
        }

        $Customers->setStatusCode($no_customer ? "0" : "0");
        $Customers->setStatusMessage($no_customer ? "No Customer returned" : "Total Customer:" . $customer_count);
        $Customers->setTotalRecordFound($customer_count ? $customer_count : '0');
        $Customers->setTotalRecordSent($customer_count ? $customer_count : '0');

        $customersMetadata = array();
        foreach ($customersArray as $customer) {
            $CustomerObj = new WG_Customer();
            $CustomerObj->setCustomerId($customer->ID);
            $customersMetaArray = $wpdb->get_results(" SELECT um.* FROM $wpdb->usermeta um WHERE um.user_id = " . $customer->ID . " ");

            foreach ($customersMetaArray as $customersMeta) {
                $customersMetadata[$customersMeta->meta_key] = $customersMeta->meta_value;
            }

            $cusCountryCode = $customersMetadata["billing_country"];
            $cusStateCode = $customersMetadata["billing_state"];

            $countries_obj = new WC_Countries();
            $countries_array = $countries_obj->get_countries();
            $country_states_array = $countries_obj->get_states();

            // Get the country name:
            $country_name = $countries_array[$cusCountryCode];

            // Get the state name:
            $state_name = $country_states_array[$cusCountryCode][$cusStateCode];

            $CustomerObj->setFirstName($customersMetadata['first_name']);
            $CustomerObj->setMiddleName('');
            $CustomerObj->setLastName($customersMetadata['last_name']);
            $CustomerObj->setcompany($customersMetadata["billing_company"]);
            $CustomerObj->setemail($customer->user_email);
            $CustomerObj->setAddress1($customersMetadata['billing_address_1']);
            $CustomerObj->setAddress2($customersMetadata['billing_address_2'] ? $customersMetadata['billing_address_2'] : "");
            $CustomerObj->setCity($customersMetadata["billing_city"]);
            $CustomerObj->setZip($customersMetadata["billing_postcode"]);

            $CustomerObj->setStateCode($customersMetadata["billing_state"]);
            $CustomerObj->setCountryCode($customersMetadata["billing_country"]);

            $CustomerObj->setState($state_name);
            $CustomerObj->setCountry($country_name);

            $CustomerObj->setPhone($customersMetadata["billing_phone"]);
            if (!isset($customer->user_registered) || $customer->user_registered == '') {
                $customer->user_registered = '2007-01-01 00:00:00';
            }

            $cusUpDate = $customersMetadata["last_update"];

            if (isset($cusUpDate) && $cusUpDate != '') {
                $dt = new DateTime("@$cusUpDate");
                $cusUpdatedDate = $dt->format('Y-m-d H:i:s');
            } else {
                $cusUpdatedDate = '2007-01-01 00:00:00';
            }

            $CustomerObj->setCreatedAt($customer->user_registered);
            $CustomerObj->setUpdatedAt($cusUpdatedDate); //2019-07-10 12:26:55
            $CustomerObj->setsubscribedToEmail("false");

            $Customers->setCustomer($CustomerObj->getCustomer());
            unset($state, $country);
            unset($customersMetadata);
        }

        return $this->response($Customers->getCustomers());
    }

    ##FUNCTION TO TRANSFER CUTSOMER FROM QB TO ONLINE STORE
    public function addCustomers($username, $password, $data, $storeid = 1, $others = '') {
        global $wpdb;

        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Customers = new WG_Customers();
        $Customers->setStatusCode('0');
        $Customers->setStatusMessage('All Ok');
        $customerData = $data;
        if (!is_array($customerData)) {
            $Customers->setStatusCode('9997');
            $Customers->setStatusMessage('Unknown request or request not in proper format');
            return $this->response($Customers->getCustomers());
        }

        if (count($customerData) == 0) {
            $Customers->setStatusCode('9996');
            $Customers->setStatusMessage('REQUEST tag(s) doesnt have correct input format');
            return $this->response($Customers->getCustomers());
        }

        foreach ($customerData as $k => $vCustomer) {
            $email = $vCustomer['Email'];
            $CustomerId = $vCustomer['CustomerId'];
            $firstName = $vCustomer['FirstName'];
            // $middlename = $vCustomer[''];
            $lastName = $vCustomer['LastName'];
            $company = $vCustomer['Company'];
            $address1 = $vCustomer['Address1'];
            $address2 = $vCustomer['Address2'];
            $city = $vCustomer['City'];
            if ($vCustomer['StateCode'] == '') {
                $state = $vCustomer['States'];
            } else {
                $state = $vCustomer['StateCode'];
            }
            $postCode = $vCustomer['Zip'];
            $countryCode = $vCustomer['CountryCode'];
            $phone = $vCustomer['Phone'];
            $membershipid = $vCustomer['CustomerGroup'];
            $password = wp_generate_password();
            $userName = $firstName; //$email;

            $id = wc_create_new_customer($email, '', $password);
            if (is_wp_error($id)) {
                // echo "Error : ".$id->get_error_message();
                $Customer = new WG_Customer();
                $Customer->setStatus($id->get_error_message());
                $Customer->setCustomerId('');
                $Customer->setFirstName($firstName);
                $Customer->setLastName($lastName);
                $Customer->setemail($email);
                $Customer->setCompany($company);
                $Customers->setCustomer($Customer->getCustomer());
            } else {
                update_user_meta($id, 'first_name', wc_clean($firstName));
                update_user_meta($id, 'last_name', wc_clean($lastName));

                get_currentuserinfo();
                $user_data = get_userdata($id);
                $registered_date = $user_data->user_registered;

                $billingAddress = array('first_name' => $firstName,
                    'last_name' => $lastName,
                    'company' => $company,
                    'address_1' => $address1,
                    'address_2' => $address2,
                    'city' => $city,
                    'state' => $state,
                    'postcode' => $postCode,
                    'country' => $countryCode,
                    'email' => $email,
                    'phone' => $phone,
                );
                // $shippingAddress = $billingAddress;
                ##PREPARE DATA FOR SHIPPING
                $billing_address = apply_filters('woocommerce_api_customer_billing_address', array(
                    'first_name',
                    'last_name',
                    'company',
                    'address_1',
                    'address_2',
                    'city',
                    'state',
                    'postcode',
                    'country',
                    'email',
                    'phone',
                ));

                foreach ($billing_address as $address) {
                    if (isset($billingAddress[$address])) {
                        update_user_meta($id, 'billing_' . $address, wc_clean($billingAddress[$address]));
                    }
                }

                $Customer = new WG_Customer();
                $Customer->setCustomerId($id);
                $Customer->setStatus('Success');
                $Customer->setFirstName($firstName);
                $Customer->setMiddleName("");
                $Customer->setLastName($lastName);
                $Customer->setCustomerGroup($group);
                $Customer->setemail($email);
                $Customer->setCompany($company);
                $Customer->setAddress1($address1);
                $Customer->setAddress2($address2);
                $Customer->setCity($city);
                $Customer->setState($state);
                $Customer->setZip($postCode);
                $Customer->setCountry($countryCode);
                $Customer->setPhone($phone);
                $Customer->setCreatedAt($registered_date);

                $customerMeta = get_user_meta($id);
                $cusUpDate = $customerMeta["last_update"][0];

                if (isset($cusUpDate) && $cusUpDate != '') {
                    $dt = new DateTime("@$cusUpDate");
                    $cusUpdatedDate = $dt->format('Y-m-d H:i:s');
                } else {
                    $cusUpdatedDate = '2007-01-01 00:00:00';
                }
                $Customer->setUpdatedAt($cusUpdatedDate); //2019-07-10 12:26:55

                $Customers->setCustomer($Customer->getCustomer());
            }
        }

        return $this->response($Customers->getCustomers());
    } //END OF addCustomer

    #
    # Update Orders via status type method
    # Will update Order Notes and tracking number of  order
    # Input parameter Username,Password, array (OrderID,ShippedOn,ShippedVia,ServiceUsed,TrackingNumber)
    #
    public function AutoSyncOrder($username, $password, $data, $statustype, $storeid, $others) {

        global $wpdb;

        #check for authorisation
        $status = $this->auth_user($username, $password, $xmlResponse, $root);
        if ($status != '0') {
            return $status;
        }

        // set current user
        if (preg_match('/\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/si', $username)) {
            $user = get_user_by('email', $username);
        } else {
            $user = get_user_by('login', $username);
        }
        if(isset($user->ID)) {
            wp_set_current_user($user->ID);
        }

        $Orders = new WG_Orders();

        $requestArray = $data;
        if (!is_array($requestArray)) {
            $Orders->setStatusCode("9997");
            $Orders->setStatusMessage("Unknown request or request not in proper format");
            return $this->response($Orders->getOrders());
            exit();
        }

        if (count($requestArray) == 0) {
            $Orders->setStatusCode("9996");
            $Orders->setStatusMessage("REQUEST array(s) doesnt have correct input format");
            return $this->response($Orders->getOrders());
            exit();
        }

        $no_orders = false;

        $Orders->setStatusCode("0");
        $Orders->setStatusMessage("All Ok");

        unset($order_wg);

        foreach ($requestArray as $k2 => $v) { // request
            $order = [];
            foreach ($v as $k3 => $v3) {
                $order[$k3] = $v3;
            }

            $order_id = $order['OrderID'];

            if (empty($order_id)) {
                echo "Invalid Order-" . $order['OrderID'];
                exit;
            }
            // die($order_id);

            # Check for record Existence for the Order ID
            try {
                $wcOrder = new WC_Order($order_id);
            } catch (Exception $e) {
                $result = 'Order not found';
                $Orders->setStatusCode("9997");
                $Orders->setStatusMessage("Order not exist at store!!");
                return $this->response($Orders->getOrders());exit();
            }

            $note_id = 0;
            $is_customer_note = $order['IsNotifyCustomer'] == 'Y' ? 1 : 0;

            switch ($statustype) {
                case 'paymentUpdate':
                    ### Xcart does not support Payment creation
                    $isupdated = "error";
                    break;

                case 'statusUpdate':
                    break;

                case 'notesUpdate':
                    $isupdated = "error";

                    if (empty($wcOrder->get_id())) {
                        $isupdated = 'Order not found';
                        break;
                    }

                    if (empty($order['OrderNotes'])) {
                        $isupdated = 'Order notes should not be null!!';
                        break;
                    }

                    $note_id = $wcOrder->add_order_note($order['OrderNotes'], $is_customer_note, true);
                    $isupdated = 'success';

                    break;

                case 'shipmentUpdate':
                    ### Xcart does not support Shippment creation
                    $isupdated = "error";
                    break;
            }

            $orderNote = [];
            if ($note_id) {
                $note = get_comment( $note_id );
                $last_modfied_date = date("m-d-Y H:i:s", strtotime($note->comment_date_gmt));
                $orderNote = [$note->comment_content];
            } else {
                $last_modfied_date = date("m-d-Y H:i:s", strtotime(current_time('mysql', 1)));
                $ordreNotesArr = $wpdb->get_results("SELECT comment_content FROM $wpdb->comments c WHERE c.comment_post_ID = " . $order_id . " ORDER BY c.comment_date DESC ", ARRAY_A);
                foreach ($ordreNotesArr as $k => $Notes) {
                    $orderNote = [$Notes['comment_content']];
                    $last_modfied_date = date("m-d-Y H:i:s", strtotime($Notes['comment_date_gmt']));
                    break;
                }
            }

            $query = "SELECT t.term_id, t.slug, t.name, p.ID FROM $wpdb->terms AS t INNER JOIN $wpdb->term_taxonomy AS tt ON tt.term_id = t.term_id INNER JOIN $wpdb->term_relationships AS tr ON tr.term_taxonomy_id = tt.term_taxonomy_id INNER JOIN $wpdb->posts AS p ON p.ID = tr.object_id  WHERE tt.taxonomy IN ('shop_order_status')  AND p.ID =" . $order_id;
            $orderdata = $wpdb->get_results($query, ARRAY_A);
            $orderStatus = $order['OrderStatus'];
            if (!empty($orderdata[0]['slug'])) {
                $orderStatus = $orderdata[0]['slug'];
            }

            $Order = new WG_Order();
            $Order->setOrderID($order_id);
            $Order->setStatus($isupdated);
            $Order->setLastModifiedDate($last_modfied_date);
            $Order->setOrderNotes($orderNote[0]);
            $Order->setOrderStatus($orderStatus);

            $Orders->setOrders($Order->getOrder());
        }

        return $this->response($Orders->getOrders());
    }

    ###########################################################################

    #
    # General utility functions
    #

    # function to escape html entity characters
    public function parseSpecCharsA($arr) {
        foreach ($arr as $k => $v) {
            // $arr[$k] = htmlspecialchars($v, ENT_NOQUOTES);
            $arr[$k] = addslashes(htmlentities($v, ENT_QUOTES));
        }

        return $arr;
    }

    ///create order refund
    public function CreateOrderRefund($username, $password, $requestArray) {
        global $wpdb;

        foreach ($requestArray as $k2 => $v) { // request
            foreach ($v as $k3 => $v3) {
                $order[$k3] = $v3;
            }

            $Orders = new WG_Orders();
            /* $update_note = $order['UpdateOrderNote'];
            $user = wp_authenticate_username_password('WP_User', $username, $password);
            $userID = $user->data->ID;
            $comment_author =  $user->data->display_name;
            $comment_author_email = $user->data->user_email;
            $comment_agent = $user->data->display_name;
            $comment_type = 'order_note';
            $date = date('Y-m-d H:i:s');
            if($order['IsNotifyCustomer']=='Y')
            $meta_val = 1;
            else
            $meta_val = 0;
             */
            /* $execute = $wpdb->insert( $wpdb->comments, array('comment_post_ID' => $order['OrderID'], 'comment_author' => $comment_author, 'comment_author_email' => $comment_author_email, 'comment_date' => $date, 'comment_date_gmt' => $date, 'comment_content' =>$order['OrderNotes'] ,'comment_agent' => $comment_agent ,'comment_type' => $comment_type));
            $new_comment_id = $wpdb->insert_id;
            $wpdb->insert( $wpdb->commentmeta, array('comment_id' => $new_comment_id, 'meta_key' => 'is_customer_note', 'meta_value' => $meta_val));
             */
            $date = current_time('mysql');
            $gmdate = current_time('mysql', 1);
            $orderStatus = wc_get_order_statuses();
            foreach ($orderStatus as $id => $name) {
                if ($name == ucfirst($order['OrderStatus'])) {
                    $set_status = $id;
                }
            }

            $updateQuery = "UPDATE $wpdb->posts SET post_status  = '" . $set_status . "', post_modified = '" . $date . "', post_modified_gmt = '" . $gmdate . "' WHERE ID  = " . $this->mySQLSafe($order['OrderID']) . "";
            $wpdb->query($updateQuery);

            $retitle = sprintf(__('Refund &ndash; %s', 'woocommerce'), strftime(_x('%b %d, %Y @ %I:%M %p', 'Order date parsed by strftime', 'woocommerce')));
            $postname = "refund" . date("F-j-Y-g:i-a");

            $post_data['post_title'] = $retitle;
            $post_data['post_content'] = "";
            $post_data['post_date'] = $date;
            $post_data['post_modified'] = $date;
            $post_data['post_date_gmt'] = $gmdate;
            $post_data['post_modified_gmt'] = $gmdate;
            $post_data['post_status'] = 'wc-completed';
            $post_data['comment_status'] = 'open';
            $post_data['post_type'] = 'shop_order_refund';
            $post_data['post_author'] = $userID;
            $post_data['post_name'] = $postname;
            $post_data['guid'] = '';
            $post_data['post_excerpt'] = $order['OrderNotes'];
            $post_data['post_parent'] = $order['OrderID'];

            $post_ID = wp_insert_post($post_data, $wp_error = false);

            $order_items = $wpdb->prefix . "woocommerce_order_items";
            $sqlDiscount = "SELECT order_item_id FROM $order_items WHERE order_id = '" . $order['OrderID'] . "' and order_item_type = 'coupon' ";
            $orderDiscount = $wpdb->get_results($sqlDiscount);

            $orderDiscountID = $orderDiscount[0]->order_item_id;
            if ($orderDiscountID != '') {
                $sql = "SELECT meta_key, meta_value FROM wp_woocommerce_order_itemmeta WHERE order_item_id = '" . $orderDiscountID . "' AND meta_key = 'discount_amount' ";
                $Discount = $wpdb->get_results($sql);
                $Discout_value = $Discount[0]->meta_value;
            }

            foreach ($order['CancelItemDetail'] as $k4 => $v4) {
                foreach ($v4 as $k5 => $v5) {
                    $orderRefund[$k5] = $v5;
                }

                $itemID = $orderRefund['ItemID'];
                $refundQty = $orderRefund['QtyCancel'];
                $itemPrice = $orderRefund['ItemPrice'];
                $SKU = $orderRefund['SKU'];

                if ($refundQty > 0) {
                    // AND meta_key='_price' AND pm.meta_value !=' '
                    $sql = "SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id = '" . $itemID . "' AND meta_key = '_stock' ";
                    $product_list = $wpdb->get_results($sql);

                    $ItemStock = $product_list[0]->meta_value;

                    $RefundPrice = $itemPrice * $refundQty;
                    $TotalRefundPrice = $TotalRefundPrice + $RefundPrice;

                    $totalQty = $refundQty + $ItemStock;
                    // increase refund product qty
                    update_post_meta($itemID, '_stock', $totalQty);

                    $sql1 = "SELECT order_item_id FROM $order_items WHERE order_id = '" . $order['OrderID'] . "' AND order_item_type = 'line_item' ";
                    $orderReID = $wpdb->get_results($sql1);

                    foreach ($orderReID as $orderItem) {
                        $RefundItemID = $orderItem->order_item_id;

                        $items = array(
                            'order_item_name' => $SKU,
                            'order_item_type' => 'line_item',
                        );

                        $ordeitemID = wc_add_order_item($post_ID, $items);

                        wc_add_order_item_meta($ordeitemID, '_refunded_item_id', $RefundItemID, $unique = false);
                        wc_add_order_item_meta($ordeitemID, '_line_total', '-' . $itemPrice, $unique = false);
                        wc_add_order_item_meta($ordeitemID, '_line_subtotal', '-' . $itemPrice, $unique = false);
                        wc_add_order_item_meta($ordeitemID, '_product_id', $itemID, $unique = false);
                        wc_add_order_item_meta($ordeitemID, '_qty', $refundQty, $unique = false);
                        //_line_tax_data
                    }
                }
            }

            if ($Discout_value != 0) {
                $TotalRefundPrice = $TotalRefundPrice - $Discout_value;
            }

            $post_meta = array(
                '_order_total' => '-' . $TotalRefundPrice,
                '_cart_discount_tax' => '',
                '_cart_discount' => '',
                '_order_shipping' => '',
                '_order_tax' => '',
                '_order_shipping_tax' => '',
                '_order_currency' => 'USD',
                '_refund_amount' => $TotalRefundPrice
            );

            foreach ($post_meta as $key => $value) {
                add_post_meta($post_ID, $key, $value);
            }

            $result = 'Success';
            $last_modfied_date = date("m-d-Y H:i:s", strtotime($gmdate));

            $RefundResponse = array();
            $RefundResponse['OrderID'] = $order['OrderID'];
            $RefundResponse['result'] = $result;
            $RefundResponse['OrderStatus'] = $order['OrderStatus'];
            $RefundResponse['last_modfied_date'] = $last_modfied_date;
        }

        return $RefundResponse;
    }

    public function mySQLSafe($value, $quote = "'") {
        // We are going to do this to keep the functions from contantly running
        if (empty($this->magic)) {
            // Comment this function as it is deprecated.
            // $this->magic = (bool) get_magic_quotes_gpc();
        }

        if (empty($this->escape)) {
            if (function_exists('mysql_real_escape_string')) {
                $this->escape = 'mysql_real_escape_string';
            } else {
                $this->escape = 'mysql_escape_string';
            }
        }

        if (empty($value)) {
            return $quote . $quote;
        }

        ## Stripslashes
        if ($this->magic) {
            $value = stripslashes($value);
        }

        ## Strip quotes if already in
        $value = str_replace(array("\\'", "'"), "&#39;", $value);

        ## Quote value
        $value = wc_clean($value);

        $value = $quote . trim($value) . $quote;

        return $value;
    }

    public function addOrderShipment($username, $password, $data, $storeid, $download_option_as_item) {
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        $Orders_obj = new WG_OrdersShipment();
        $requestArray = $data;
        // print_r($requestArray);die();
        if (!is_array($requestArray)) {
            $Orders_obj->setStatusCode('9997');
            $Orders_obj->setStatusMessage('Unknown request or request not in proper format');
            return $this->response($Items->getItems());
        }

        if (count($requestArray) == 0) {
            $Orders_obj->setStatusCode('9996');
            $Orders_obj->setStatusMessage('REQUEST tag(s) doesnt have correct input format');
            return $this->response($Items->getItems());
        }

        $Orders_obj->setStatusCode('0');
        $Orders_obj->setStatusMessage('WooCommerce core functionality does not have the shipment create feature. Please review it manually.');

        return $this->response($Orders_obj->getOrdersShipment());
    }


    /**
     * Determines StoreInfo
     *
     * @since 409
     *
     * @return bool
     */
    public function getStoreInfo($username, $password) {
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        include_once eCC_PLUGIN_DIR . 'webgility-config.php';

        global $woocommerce;
        if(!isset($storeMduleVersion)) {
            global $storeMduleVersion;
        }

        $woocommerce_version = !empty($woocommerce->version) ? $woocommerce->version : '';

        $plugins = get_option('active_plugins');
        $sequential_order_numbers_plugin = 'woocommerce-sequential-order-numbers/woocommerce-sequential-order-numbers.php';
        $sequential_order_numbers_plugin_pro = 'woocommerce-sequential-order-numbers-pro/woocommerce-sequential-order-numbers-pro.php';
        $sequential_order_numbers_plugin_installed = 'no';
        if (in_array($sequential_order_numbers_plugin, $plugins) || in_array($sequential_order_numbers_plugin_pro, $plugins)) {
            $sequential_order_numbers_plugin_installed = 'yes';
        }

        $hpos_enabled = $this->is_hpos_enabled() ? 'yes' : 'no';
        $hpos_compatibility_mode_enabled = $this->is_hpos_sync_enabled() ? 'yes' : 'no';
        $download_orders_with_order_number = get_option('webgility_order_number') == 1 ? 'yes' : 'no';
        $sync_sale_price = get_option('webgility_wgsaleprice') == 1 ? 'yes' : 'no';

        $storeInfo = array(
            'php_version' => phpversion(),
            'woocommerce_version' => $woocommerce_version,
            'hpos_enabled' => $hpos_enabled,
            'hpos_compatibility_mode_enabled' => $hpos_compatibility_mode_enabled,
            'sequential_order_numbers_plugin_installed' => $sequential_order_numbers_plugin_installed,
            'store_module_version' => $storeMduleVersion,
            'download_orders_with_order_number' => $download_orders_with_order_number,
            'sync_sale_price' => $sync_sale_price,
        );

        return $this->response($storeInfo);
    }


    /**
     * Determines orderIds.
     *
     * @since 409
     *
     * @return bool
     */
    public function getOrderIds($username, $password, $args) {
        $status = $this->auth_user($username, $password);
        if ($status != '0') {
            return $status;
        }

        if (empty($args['type'])) {
            $args['type'] = 'shop_order';
        }

        if (empty($args['return'])) {
            $args['return'] = 'ids';
        }

        if (empty($args['paginate'])) {
            $args['paginate'] = true;
        }

        $orders = wc_get_orders( $args );
        $response = json_decode(json_encode($orders), true);
        return $this->response($response);
    }

    /**
     * Determines whether HPOS is in use.
     *
     * @since 409
     *
     * @return bool
     */
    protected function is_hpos_enabled() {
        return class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )
            && \Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled();
    }

    /**
     * Determines whether HPOS is in use.
     *
     * @since 409
     *
     * @return bool
     */
    protected function is_hpos_sync_enabled() {
        return class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )
            && \Automattic\WooCommerce\Utilities\OrderUtil::is_custom_order_tables_in_sync();
    }
} // Class end

// ob_clean(); ob_start();
if (isset($_REQUEST['request'])) {
    $wpObject = new Webgility_Ecc_WP();
    $wpObject->parseRequest();
}

function gmdate_to_mydate($gmdate) {
    /* $gmdate must be in YYYY-mm-dd H:i:s format*/
    $timezone = date_default_timezone_get();
    $userTimezone = new DateTimeZone($timezone);

    $gmtTimezone = new DateTimeZone('GMT');
    $myDateTime = new DateTime($gmdate, $gmtTimezone);

    $offset = $userTimezone->getOffset($myDateTime);

    return date("Y-m-d H:i:s", strtotime($gmdate) + $offset);
}
